/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.layout;

import android.view.View;
import java.util.Map;
import org.nuxeo.android.layout.ActivityResultHandler;
import org.nuxeo.android.layout.WidgetDefinition;
import org.nuxeo.android.layout.widgets.AndroidWidgetWrapper;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;

public class NuxeoWidget {
    protected final WidgetDefinition widgetDef;
    protected final View view;
    protected final AndroidWidgetWrapper wrapper;

    public NuxeoWidget(WidgetDefinition widgetDef, View view, AndroidWidgetWrapper wrapper) {
        this.widgetDef = widgetDef;
        this.view = view;
        this.wrapper = wrapper;
        if (wrapper == null) {
            throw new RuntimeException("No native Widget wrapper registred for WidgetType " + widgetDef.getType());
        }
    }

    public void applyChanges(Document doc) {
        if (this.view == null) {
            throw new RuntimeException("Can not apply changes with a null view");
        }
        this.wrapper.updateModel(doc);
    }

    public void refresh(Document doc) {
        if (this.view == null) {
            throw new RuntimeException("Can not refresh a null view");
        }
        this.wrapper.refreshViewFromDocument(doc);
    }

    public Map<Integer, ActivityResultHandler> getAndFlushPendingActivityResultHandler() {
        return this.wrapper.getAndFlushPendingActivityResultHandler();
    }

    public WidgetDefinition getWidgetDef() {
        return this.widgetDef;
    }

    public View getView() {
        return this.view;
    }
}

