/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.layout;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.List;
import org.json.JSONObject;
import org.nuxeo.android.layout.LayoutContext;
import org.nuxeo.android.layout.LayoutMode;
import org.nuxeo.android.layout.NuxeoWidget;
import org.nuxeo.android.layout.selectOptions.SelectOptions;
import org.nuxeo.android.layout.widgets.AndroidWidgetMapper;
import org.nuxeo.android.layout.widgets.AndroidWidgetWrapper;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;

public class WidgetDefinition {
    protected String name;
    protected String type;
    protected String label;
    protected List<String> attributeNames;
    protected LayoutMode mode;
    protected SelectOptions selectOptions;
    protected JSONObject properties;

    public WidgetDefinition(String name, String type, String label, List<String> fieldNames, JSONObject properties) {
        this.name = name;
        this.type = type;
        this.label = label;
        this.attributeNames = fieldNames;
        this.properties = properties;
    }

    public String getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public NuxeoWidget build(LayoutContext context, Document doc, ViewGroup parent, LayoutMode mode) {
        AndroidWidgetWrapper wrapper;
        this.mode = mode;
        View view = null;
        LinearLayout.LayoutParams labelLayoutParams = new LinearLayout.LayoutParams(-1, -2, 1.0f);
        LinearLayout.LayoutParams widgetLayoutParams = new LinearLayout.LayoutParams(-1, -2, 1.0f);
        if (LayoutMode.VIEW == mode) {
            labelLayoutParams = new LinearLayout.LayoutParams(-1, -2, 0.6f);
            widgetLayoutParams = new LinearLayout.LayoutParams(-1, -2, 0.4f);
        }
        if ((wrapper = AndroidWidgetMapper.getInstance().getWidgetWrapper(this)) != null) {
            view = wrapper.buildView(context, mode, doc, this.attributeNames, this);
            view.setLayoutParams((ViewGroup.LayoutParams)widgetLayoutParams);
            view.setPadding(1, 1, 1, 1);
            if (LayoutMode.VIEW == mode) {
                view.setBackgroundColor(Color.rgb((int)240, (int)240, (int)250));
            }
        }
        if (view != null) {
            if (this.label != null) {
                TextView labelW = new TextView((Context)context.getActivity());
                labelW.setText((CharSequence)(this.label + " :"));
                labelW.setTextColor(Color.rgb((int)80, (int)80, (int)80));
                labelW.setLayoutParams((ViewGroup.LayoutParams)labelLayoutParams);
                parent.addView((View)labelW);
                if (LayoutMode.VIEW != mode) {
                    labelW.setBackgroundColor(Color.rgb((int)160, (int)160, (int)170));
                    labelW.setTextColor(Color.rgb((int)20, (int)20, (int)40));
                    labelW.setPadding(5, 5, 5, 5);
                }
            }
            parent.addView(view);
            return new NuxeoWidget(this, view, wrapper);
        }
        return null;
    }

    public SelectOptions getSelectOptions() {
        if (this.selectOptions == null) {
            return new SelectOptions();
        }
        return this.selectOptions;
    }

    public void setSelectOptions(SelectOptions selectOptions) {
        this.selectOptions = selectOptions;
    }

    public String getAttributeName() {
        return this.attributeNames.get(0);
    }

    public List<String> getAttributeNames() {
        return this.attributeNames;
    }

    public LayoutMode getMode() {
        return this.mode;
    }

    public JSONObject getProperties() {
        if (this.properties == null) {
            this.properties = new JSONObject();
        }
        return this.properties;
    }
}

