/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.layout.selectOptions;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SelectOptions {
    protected List<String> itemValues = new ArrayList<String>();
    protected List<String> itemLabels = new ArrayList<String>();

    public SelectOptions() {
    }

    public SelectOptions(JSONArray array) {
        for (int i = 0; i < array.length(); ++i) {
            try {
                JSONObject ob = array.getJSONObject(i);
                this.add(ob.getString("itemValue"), ob.getString("itemLabel"));
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void add(String itemValue, String itemLabel) {
        this.itemValues.add(itemValue);
        this.itemLabels.add(itemLabel);
    }

    public List<String> getItemValues() {
        return this.itemValues;
    }

    public List<String> getItemLabels() {
        return this.itemLabels;
    }

    public String getItemValue(int idx) {
        return this.itemValues.get(idx);
    }

    public String getItemLabel(int idx) {
        return this.itemLabels.get(idx);
    }

    public int getValueIndex(String value) {
        if (value == null) {
            return -1;
        }
        for (int i = 0; i < this.itemValues.size(); ++i) {
            if (!this.itemValues.get(i).equals(value)) continue;
            return i;
        }
        return -1;
    }

    public int getLabelIndex(String value) {
        if (value == null) {
            return -1;
        }
        for (int i = 0; i < this.itemLabels.size(); ++i) {
            if (!this.itemLabels.get(i).equals(value)) continue;
            return i;
        }
        return -1;
    }

    public String getLabel(String value) {
        int idx = this.getValueIndex(value);
        if (idx >= 0) {
            return this.itemLabels.get(idx);
        }
        return value;
    }
}

