/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.layout.widgets;

import android.content.Context;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import android.util.Log;
import android.webkit.MimeTypeMap;
import android.widget.Toast;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.FileNameMap;
import java.net.URLConnection;
import org.nuxeo.android.layout.ActivityResultHandler;
import org.nuxeo.ecm.automation.client.jaxrs.model.Blob;
import org.nuxeo.ecm.automation.client.jaxrs.model.FileBlob;
import org.nuxeo.ecm.automation.client.jaxrs.model.StreamBlob;

public abstract class ActivityResultUriToFileHandler
implements ActivityResultHandler {
    protected Context context;
    protected FileNameMap fileNameMap = URLConnection.getFileNameMap();
    protected File targetFile;

    public ActivityResultUriToFileHandler(Context context) {
        this.context = context;
    }

    public ActivityResultUriToFileHandler(Context context, File targetFile) {
        this.context = context;
        this.targetFile = targetFile;
    }

    @Override
    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            if (data == null && this.targetFile != null) {
                FileBlob blob = new FileBlob(this.targetFile);
                String mimeType = this.fileNameMap.getContentTypeFor(this.targetFile.getName());
                blob.setMimeType(mimeType);
                this.onStreamBlobAvailable(blob);
                return true;
            }
            Uri dataUri = data.getData();
            if (dataUri != null) {
                AssetFileDescriptor afd = null;
                String mimeType = null;
                String fileName = null;
                try {
                    afd = this.context.getContentResolver().openAssetFileDescriptor(dataUri, "r");
                    mimeType = this.context.getContentResolver().getType(dataUri);
                    if (dataUri.toString().startsWith("file://")) {
                        fileName = dataUri.getLastPathSegment();
                    }
                    if (mimeType == null && fileName != null) {
                        mimeType = this.fileNameMap.getContentTypeFor(fileName);
                    }
                    if (fileName == null) {
                        fileName = dataUri.getEncodedPath().replace("/", "_");
                        if (mimeType != null) {
                            String ext = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType);
                            fileName = fileName + "." + ext;
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    this.handleError("can not handle uri" + dataUri.toString(), e);
                    return false;
                }
                try {
                    StreamBlob blob = new StreamBlob(afd.createInputStream(), fileName, mimeType);
                    this.onStreamBlobAvailable(blob);
                }
                catch (IOException e) {
                    this.handleError("Can not read the stream" + dataUri.toString(), e);
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    protected void handleError(String message, Exception e) {
        Log.e((String)this.getClass().getSimpleName(), (String)message, (Throwable)e);
        Toast.makeText((Context)this.context, (CharSequence)message, (int)1).show();
    }

    protected abstract void onStreamBlobAvailable(Blob var1);
}

