/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.layout.widgets;

import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.android.layout.WidgetDefinition;
import org.nuxeo.android.layout.widgets.AndroidWidgetWrapper;
import org.nuxeo.android.layout.widgets.BlobWidgetWrapper;
import org.nuxeo.android.layout.widgets.CheckBoxWidgetWrapper;
import org.nuxeo.android.layout.widgets.DateWidgetWrapper;
import org.nuxeo.android.layout.widgets.ReadOnlyTextWidgetWrapper;
import org.nuxeo.android.layout.widgets.RichTextWidgetWrapper;
import org.nuxeo.android.layout.widgets.SpinnerMultiWidgetWrapper;
import org.nuxeo.android.layout.widgets.SpinnerWidgetWrapper;
import org.nuxeo.android.layout.widgets.TextAreaWidgetWrapper;
import org.nuxeo.android.layout.widgets.TextWidgetWrapper;

public class AndroidWidgetMapper {
    protected static AndroidWidgetMapper instance = null;
    protected static final Map<String, Class<? extends AndroidWidgetWrapper>> wrappers = new HashMap<String, Class<? extends AndroidWidgetWrapper>>();

    protected AndroidWidgetMapper() {
        this.registerDefaultWrappers();
    }

    public static AndroidWidgetMapper getInstance() {
        if (instance == null) {
            instance = new AndroidWidgetMapper();
        }
        return instance;
    }

    public static void registerWidgetWrapper(String type, Class<? extends AndroidWidgetWrapper> wrapperClass) {
        wrappers.put(type, wrapperClass);
    }

    protected void registerDefaultWrappers() {
        AndroidWidgetMapper.registerWidgetWrapper("text", TextWidgetWrapper.class);
        AndroidWidgetMapper.registerWidgetWrapper("readonlytext", ReadOnlyTextWidgetWrapper.class);
        AndroidWidgetMapper.registerWidgetWrapper("date", DateWidgetWrapper.class);
        AndroidWidgetMapper.registerWidgetWrapper("datetime", DateWidgetWrapper.class);
        AndroidWidgetMapper.registerWidgetWrapper("selectOneDirectory", SpinnerWidgetWrapper.class);
        AndroidWidgetMapper.registerWidgetWrapper("selectManyDirectory", SpinnerMultiWidgetWrapper.class);
        AndroidWidgetMapper.registerWidgetWrapper("blob", BlobWidgetWrapper.class);
        AndroidWidgetMapper.registerWidgetWrapper("image", BlobWidgetWrapper.class);
        AndroidWidgetMapper.registerWidgetWrapper("textarea", TextAreaWidgetWrapper.class);
        AndroidWidgetMapper.registerWidgetWrapper("richtext_with_mimetype", RichTextWidgetWrapper.class);
        AndroidWidgetMapper.registerWidgetWrapper("checkbox", CheckBoxWidgetWrapper.class);
    }

    protected String getAndroidWidgetType(WidgetDefinition wDef) {
        String templateName;
        if (wrappers.keySet().contains(wDef.getType())) {
            return wDef.getType();
        }
        if ("template".equals(wDef.getType()) && (templateName = wDef.getProperties().optString("template")) != null) {
            if (templateName.contains("contributors")) {
                return "text";
            }
            if (templateName.contains("extended_file_widget")) {
                return "blob";
            }
            if (templateName.contains("single_user_widget_template")) {
                return "readonlytext";
            }
            if (templateName.contains("single_user_widget_template")) {
                return "readonlytext";
            }
            if (templateName.contains("subjects_widget")) {
                return "selectManyDirectory";
            }
            if (templateName.contains("coverage_widget")) {
                return "selectOneDirectory";
            }
        }
        return null;
    }

    public AndroidWidgetWrapper getWidgetWrapper(WidgetDefinition wDef) {
        try {
            String type = this.getAndroidWidgetType(wDef);
            if (type == null) {
                Log.w((String)this.getClass().getSimpleName(), (String)("No Widget mapping found for type " + wDef.getType() + " with name " + wDef.getName()));
                return null;
            }
            Class<? extends AndroidWidgetWrapper> wrapperClass = wrappers.get(type);
            AndroidWidgetWrapper wrapper = wrapperClass.newInstance();
            return wrapper;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

