/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.layout.widgets;

import android.app.Activity;
import android.content.Context;
import android.support.v4.app.Fragment;
import android.view.View;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.android.context.NuxeoContext;
import org.nuxeo.android.layout.ActivityResultHandler;
import org.nuxeo.android.layout.ActivityResultHandlerRegistry;
import org.nuxeo.android.layout.LayoutContext;
import org.nuxeo.android.layout.LayoutMode;
import org.nuxeo.android.layout.WidgetDefinition;
import org.nuxeo.ecm.automation.client.android.AndroidAutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;

public abstract class BaseAndroidWidgetWrapper<T>
implements ActivityResultHandlerRegistry {
    protected final Map<Integer, ActivityResultHandler> pendingActivityResultHandlers = new HashMap<Integer, ActivityResultHandler>();
    protected List<String> attributeNames;
    protected T currentValue;
    protected WidgetDefinition widgetDef;
    protected LayoutMode mode;
    protected LayoutContext layoutContext;

    @Override
    public void registerActivityResultHandler(int requestCode, ActivityResultHandler handler) {
        this.pendingActivityResultHandlers.put(requestCode, handler);
    }

    public Map<Integer, ActivityResultHandler> getAndFlushPendingActivityResultHandler() {
        HashMap<Integer, ActivityResultHandler> pending = new HashMap<Integer, ActivityResultHandler>(this.pendingActivityResultHandlers);
        this.pendingActivityResultHandlers.clear();
        return pending;
    }

    protected AndroidAutomationClient getClient() {
        return NuxeoContext.get(this.layoutContext.getActivity().getApplicationContext()).getNuxeoClient();
    }

    protected String getAttributeName() {
        if (this.attributeNames == null || this.attributeNames.size() == 0) {
            return null;
        }
        return this.attributeNames.get(0);
    }

    protected List<String> getAttributeNames() {
        return this.attributeNames;
    }

    protected void setAttributeName(String attributeName) {
        this.attributeNames.set(0, attributeName);
    }

    protected void setAttributeNames(List<String> attributeNames) {
        this.attributeNames = attributeNames;
    }

    protected abstract void initCurrentValueFromDocument(Document var1);

    protected T getCurrentValue() {
        return this.currentValue;
    }

    protected void setCurrentValue(T value) {
        this.currentValue = value;
    }

    public View buildView(LayoutContext context, LayoutMode mode, Document doc, List<String> attributeNames, WidgetDefinition widgetDef) {
        this.setAttributeNames(attributeNames);
        this.initCurrentValueFromDocument(doc);
        this.widgetDef = widgetDef;
        this.mode = mode;
        this.layoutContext = context;
        return null;
    }

    protected Context getRootContext() {
        return this.layoutContext.getActivity();
    }

    protected Activity getHomeActivity() {
        return this.layoutContext.getActivity();
    }

    protected Fragment getFragment() {
        return this.layoutContext.getFragment();
    }

    protected LayoutContext getLayoutContext() {
        return this.layoutContext;
    }
}

