/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.layout.widgets;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Random;
import org.nuxeo.android.adapters.DocumentAttributeResolver;
import org.nuxeo.android.cache.blob.BlobStoreManager;
import org.nuxeo.android.cache.blob.BlobWithProperties;
import org.nuxeo.android.contentprovider.NuxeoContentProviderConfig;
import org.nuxeo.android.layout.LayoutContext;
import org.nuxeo.android.layout.LayoutMode;
import org.nuxeo.android.layout.WidgetDefinition;
import org.nuxeo.android.layout.widgets.ActivityResultUriToFileHandler;
import org.nuxeo.android.layout.widgets.AndroidWidgetWrapper;
import org.nuxeo.android.layout.widgets.BaseAndroidWidgetWrapper;
import org.nuxeo.android.upload.FileUploader;
import org.nuxeo.ecm.automation.client.android.UIAsyncCallback;
import org.nuxeo.ecm.automation.client.jaxrs.AsyncCallbackWithProgress;
import org.nuxeo.ecm.automation.client.jaxrs.model.Blob;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyMap;

public class BlobWidgetWrapper
extends BaseAndroidWidgetWrapper<PropertyMap>
implements AndroidWidgetWrapper {
    protected static final int REQUEST_CODE_BASE = new Random().nextInt(1000);
    protected static final int PICK_IMG = REQUEST_CODE_BASE + 0;
    protected static final int PICK_ANY = REQUEST_CODE_BASE + 1;
    protected static final int TAKE_PICTURE = REQUEST_CODE_BASE + 2;
    protected int uploadInProgress = 0;
    protected boolean changedValue = false;
    protected LinearLayout layoutWidget;
    protected LinearLayout fileAttributes;
    protected TextView filename;
    protected TextView size;
    protected TextView mimetype;
    protected ProgressBar progressBar;
    protected LinearLayout buttonLayout;
    protected Button uploadImg;
    protected Button uploadFile;
    protected Button takePicture;
    protected Button openBtn;
    protected AsyncCallbackWithProgress<Serializable> uploadCB;
    protected File targetImageFile;

    @Override
    public boolean validateBeforeModelUpdate() {
        if (this.uploadInProgress > 0) {
            Toast.makeText((Context)this.getRootContext(), (CharSequence)"File upload is still in progress", (int)0).show();
            return false;
        }
        return true;
    }

    @Override
    public void updateModel(Document doc) {
        if (this.mode != LayoutMode.VIEW && this.currentValue != null && this.changedValue) {
            doc.set(this.getAttributeName(), (PropertyMap)this.currentValue);
        }
    }

    protected void applyBinding() {
        if (this.currentValue == null) {
            this.filename.setText((CharSequence)"No Blob!");
            this.size.setVisibility(4);
            this.mimetype.setVisibility(4);
        } else {
            this.filename.setText((CharSequence)((PropertyMap)this.currentValue).getString("name"));
            this.size.setVisibility(0);
            this.mimetype.setVisibility(0);
            this.size.setText((CharSequence)("(" + ((PropertyMap)this.currentValue).getString("length") + " bytes )"));
            this.mimetype.setText((CharSequence)("[" + ((PropertyMap)this.currentValue).getString("mime-type") + "]"));
        }
        if (this.mode != LayoutMode.VIEW) {
            this.progressBar.setVisibility(0);
        }
        this.filename.invalidate();
        this.size.invalidate();
        this.mimetype.invalidate();
        if (this.progressBar != null) {
            this.progressBar.invalidate();
        }
        this.layoutWidget.invalidate();
    }

    @Override
    public View buildView(LayoutContext context, LayoutMode mode, Document doc, List<String> attributeNames, WidgetDefinition widgetDef) {
        super.buildView(context, mode, doc, attributeNames, widgetDef);
        Activity ctx = context.getActivity();
        this.layoutWidget = new LinearLayout((Context)context.getActivity());
        this.layoutWidget.setOrientation(1);
        this.fileAttributes = new LinearLayout((Context)context.getActivity());
        this.fileAttributes.setOrientation(0);
        this.filename = new TextView((Context)ctx);
        this.layoutWidget.addView((View)this.filename);
        this.size = new TextView((Context)ctx);
        this.mimetype = new TextView((Context)ctx);
        this.fileAttributes.addView((View)this.size);
        this.fileAttributes.addView((View)this.mimetype);
        if (mode == LayoutMode.VIEW) {
            this.openBtn = new Button(this.layoutWidget.getContext());
            this.fileAttributes.addView((View)this.openBtn);
            this.openBtn.setBackgroundResource(17301549);
            String uriString = "content://" + NuxeoContentProviderConfig.getAuthority() + "/blobs/" + doc.getId() + "/" + this.getAttributeName();
            final Uri contentUri = Uri.parse((String)uriString);
            this.openBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(contentUri);
                    intent.setFlags(0x4000000);
                    try {
                        BlobWidgetWrapper.this.getHomeActivity().startActivity(intent);
                    }
                    catch (ActivityNotFoundException e) {
                        Log.e((String)BlobWidgetWrapper.class.getSimpleName(), (String)"Unable to start blob viewer", (Throwable)e);
                        Toast.makeText((Context)BlobWidgetWrapper.this.getRootContext(), (CharSequence)"No Application Available to View blob", (int)0).show();
                    }
                }
            });
        }
        this.layoutWidget.addView((View)this.fileAttributes);
        if (mode != LayoutMode.VIEW) {
            this.progressBar = new ProgressBar((Context)ctx, null, 16842872);
            this.progressBar.setMax(100);
            this.progressBar.setVisibility(4);
            this.layoutWidget.addView((View)this.progressBar);
            this.buttonLayout = new LinearLayout(this.layoutWidget.getContext());
            this.buttonLayout.setOrientation(0);
            this.layoutWidget.addView((View)this.buttonLayout);
            this.uploadImg = new Button(this.layoutWidget.getContext());
            this.buttonLayout.addView((View)this.uploadImg);
            this.uploadImg.setTag((Object)("img:" + this.getAttributeName()));
            this.uploadImg.setBackgroundResource(17301567);
            this.uploadImg.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    BlobWidgetWrapper.this.progressBar.setVisibility(0);
                    BlobWidgetWrapper.this.progressBar.invalidate();
                    BlobWidgetWrapper.this.registerActivityResultHandler(PICK_IMG, BlobWidgetWrapper.this.getHandler(BlobWidgetWrapper.this.getLayoutContext().getLayoutId()));
                    if (BlobWidgetWrapper.this.getFragment() != null) {
                        BlobWidgetWrapper.this.getFragment().startActivityForResult(new Intent("android.intent.action.PICK").setType("image/*"), PICK_IMG);
                    } else {
                        BlobWidgetWrapper.this.getHomeActivity().startActivityForResult(new Intent("android.intent.action.PICK").setType("image/*"), PICK_IMG);
                    }
                }
            });
            this.uploadFile = new Button(this.layoutWidget.getContext());
            this.buttonLayout.addView((View)this.uploadFile);
            this.uploadFile.setTag((Object)("file:" + this.getAttributeName()));
            this.uploadFile.setBackgroundResource(17301589);
            this.uploadFile.setOnClickListener(new View.OnClickListener(){

                public void onClick(View arg0) {
                    BlobWidgetWrapper.this.progressBar.setVisibility(0);
                    BlobWidgetWrapper.this.progressBar.invalidate();
                    BlobWidgetWrapper.this.registerActivityResultHandler(PICK_ANY, BlobWidgetWrapper.this.getHandler(BlobWidgetWrapper.this.getLayoutContext().getLayoutId()));
                    Intent intent = new Intent("android.intent.action.GET_CONTENT");
                    intent.setType("file/*");
                    intent.putExtra("org.openintents.extra.TITLE", "Select a file to attach");
                    try {
                        if (BlobWidgetWrapper.this.getFragment() != null) {
                            BlobWidgetWrapper.this.getFragment().startActivityForResult(intent, PICK_ANY);
                        } else {
                            BlobWidgetWrapper.this.getHomeActivity().startActivityForResult(intent, PICK_ANY);
                        }
                    }
                    catch (ActivityNotFoundException e) {
                        Log.e((String)BlobWidgetWrapper.class.getSimpleName(), (String)"Unable to find any application to pick files", (Throwable)e);
                        Toast.makeText((Context)BlobWidgetWrapper.this.getRootContext(), (CharSequence)"Unable to find any application to pick files", (int)0).show();
                    }
                }
            });
            this.takePicture = new Button(this.layoutWidget.getContext());
            this.buttonLayout.addView((View)this.takePicture);
            this.takePicture.setTag((Object)("file:" + this.getAttributeName()));
            this.takePicture.setBackgroundResource(17301559);
            this.takePicture.setOnClickListener(new View.OnClickListener(){

                public void onClick(View arg0) {
                    BlobWidgetWrapper.this.progressBar.setVisibility(0);
                    BlobWidgetWrapper.this.progressBar.invalidate();
                    Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
                    File cacheDir = BlobStoreManager.getRootCacheDir(BlobWidgetWrapper.this.getHomeActivity().getApplicationContext());
                    try {
                        BlobWidgetWrapper.this.targetImageFile = File.createTempFile("NewPicture", ".jpg", cacheDir);
                        intent.putExtra("output", (Parcelable)Uri.fromFile((File)BlobWidgetWrapper.this.targetImageFile));
                        BlobWidgetWrapper.this.registerActivityResultHandler(TAKE_PICTURE, BlobWidgetWrapper.this.getHandler(BlobWidgetWrapper.this.getLayoutContext().getLayoutId()));
                        if (BlobWidgetWrapper.this.getFragment() != null) {
                            BlobWidgetWrapper.this.getFragment().startActivityForResult(intent, TAKE_PICTURE);
                        } else {
                            BlobWidgetWrapper.this.getHomeActivity().startActivityForResult(intent, TAKE_PICTURE);
                        }
                    }
                    catch (IOException e) {
                        Log.e((String)BlobWidgetWrapper.this.getClass().getSimpleName(), (String)"Unable to get file for image transfert", (Throwable)e);
                    }
                }
            });
        }
        this.applyBinding();
        this.uploadCB = new UIAsyncCallback<Serializable>(){

            @Override
            public void onErrorUI(String executionId, Throwable e) {
                --BlobWidgetWrapper.this.uploadInProgress;
                Toast.makeText((Context)BlobWidgetWrapper.this.getRootContext(), (CharSequence)"File upload failed", (int)0).show();
            }

            @Override
            public void onProgressUpdate(int progress) {
                BlobWidgetWrapper.this.progressBar.setProgress(progress);
                BlobWidgetWrapper.this.progressBar.invalidate();
            }

            @Override
            public void onSuccessUI(String executionId, Serializable data) {
                BlobWidgetWrapper.this.progressBar.invalidate();
                --BlobWidgetWrapper.this.uploadInProgress;
                Toast.makeText((Context)BlobWidgetWrapper.this.getRootContext(), (CharSequence)"File upload completed", (int)0).show();
            }

            @Override
            public void onStart() {
                BlobWidgetWrapper.this.progressBar.setVisibility(0);
                BlobWidgetWrapper.this.progressBar.invalidate();
                Toast.makeText((Context)BlobWidgetWrapper.this.getRootContext(), (CharSequence)"File upload started ...", (int)0).show();
            }
        };
        return this.layoutWidget;
    }

    @Override
    public void refreshViewFromDocument(Document doc) {
        this.initCurrentValueFromDocument(doc);
        this.applyBinding();
    }

    @Override
    protected void initCurrentValueFromDocument(Document doc) {
        Object blobField = DocumentAttributeResolver.get(doc, this.getAttributeName());
        this.currentValue = null;
        if (blobField != null && blobField instanceof PropertyMap) {
            this.currentValue = (PropertyMap)blobField;
        } else if (blobField != null) {
            Log.d((String)this.getClass().getSimpleName(), (String)blobField.toString());
        }
    }

    protected ActivityResultUriToFileHandler getHandler(final String batchId) {
        return new ActivityResultUriToFileHandler(this.getRootContext(), this.targetImageFile){

            @Override
            protected void onStreamBlobAvailable(Blob blobToUpload) {
                Log.i((String)BlobWidgetWrapper.class.getSimpleName(), (String)("Started blob upload with batchId " + batchId));
                BlobWithProperties blobUploading = BlobWidgetWrapper.this.startUpload(blobToUpload, batchId);
                String uploadUUID = blobUploading.getProperty("uuid");
                Log.i((String)BlobWidgetWrapper.class.getSimpleName(), (String)("Started blob upload UUID " + uploadUUID));
                PropertyMap blobProp = new PropertyMap();
                blobProp.set("type", "blob");
                blobProp.set("length", new Long(blobUploading.getLength()));
                blobProp.set("mime-type", blobUploading.getMimeType());
                blobProp.set("name", blobToUpload.getFileName());
                blobProp.set("upload-batch", batchId);
                blobProp.set("upload-fileId", blobUploading.getFileName());
                blobProp.set("android-require-type", "upload");
                blobProp.set("android-require-uuid", uploadUUID);
                BlobWidgetWrapper.this.setCurrentValue(blobProp);
                BlobWidgetWrapper.this.changedValue = true;
                BlobWidgetWrapper.this.applyBinding();
            }
        };
    }

    protected BlobWithProperties startUpload(Blob blobToUpload, String batchId) {
        BlobWithProperties result = null;
        if (blobToUpload.getFileName() == null) {
            blobToUpload.setFileName(this.getAttributeName());
        }
        String fileId = blobToUpload.getFileName();
        FileUploader uploader = this.getClient().getFileUploader();
        if (this.getClient().getNetworkStatus().canUseNetwork()) {
            this.progressBar.setVisibility(0);
            result = uploader.storeAndUpload(batchId, fileId, blobToUpload, this.uploadCB);
            ++this.uploadInProgress;
        } else {
            Toast.makeText((Context)this.getRootContext(), (CharSequence)"File will be uploaded when network is back", (int)0).show();
            result = uploader.storeFileForUpload(batchId, fileId, blobToUpload);
        }
        return result;
    }
}

