/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.layout.widgets;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.CheckBox;
import java.util.List;
import org.nuxeo.android.adapters.DocumentAttributeResolver;
import org.nuxeo.android.layout.LayoutContext;
import org.nuxeo.android.layout.LayoutMode;
import org.nuxeo.android.layout.WidgetDefinition;
import org.nuxeo.android.layout.widgets.AndroidWidgetWrapper;
import org.nuxeo.android.layout.widgets.BaseAndroidWidgetWrapper;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;

public class CheckBoxWidgetWrapper
extends BaseAndroidWidgetWrapper<Boolean>
implements AndroidWidgetWrapper {
    protected CheckBox checkbox;

    @Override
    protected void initCurrentValueFromDocument(Document doc) {
        Object value = DocumentAttributeResolver.get(doc, this.getAttributeName());
        Boolean bValue = false;
        if (value != null) {
            if (value instanceof Boolean) {
                bValue = (Boolean)value;
            } else if (value instanceof String) {
                bValue = Boolean.parseBoolean((String)value);
            }
        }
        this.setCurrentValue(bValue);
    }

    @Override
    public void refreshViewFromDocument(Document doc) {
        this.initCurrentValueFromDocument(doc);
        this.applyBinding();
    }

    protected void applyBinding() {
        this.checkbox.setChecked(((Boolean)this.getCurrentValue()).booleanValue());
        if (LayoutMode.VIEW == this.mode) {
            this.checkbox.setEnabled(false);
        }
    }

    @Override
    public View buildView(LayoutContext context, LayoutMode mode, Document doc, List<String> attributeNames, WidgetDefinition widgetDef) {
        super.buildView(context, mode, doc, attributeNames, widgetDef);
        Activity ctx = context.getActivity();
        this.checkbox = new CheckBox((Context)ctx);
        return this.checkbox;
    }

    @Override
    public void updateModel(Document doc) {
        if (this.mode == LayoutMode.EDIT) {
            doc.set(this.getAttributeName(), new Boolean(this.checkbox.isChecked()).toString());
        }
    }

    @Override
    public boolean validateBeforeModelUpdate() {
        return true;
    }
}

