/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.layout.widgets;

import android.app.Activity;
import android.app.DatePickerDialog;
import android.content.Context;
import android.view.View;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.nuxeo.android.adapters.DocumentAttributeResolver;
import org.nuxeo.android.layout.LayoutContext;
import org.nuxeo.android.layout.LayoutMode;
import org.nuxeo.android.layout.WidgetDefinition;
import org.nuxeo.android.layout.widgets.AndroidWidgetWrapper;
import org.nuxeo.android.layout.widgets.BaseAndroidWidgetWrapper;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;

public class DateWidgetWrapper
extends BaseAndroidWidgetWrapper<Calendar>
implements AndroidWidgetWrapper,
View.OnClickListener,
DatePickerDialog.OnDateSetListener {
    protected static SimpleDateFormat fmt = new SimpleDateFormat("yyyy/MM/dd");
    protected LinearLayout layout;
    protected TextView txt;
    protected Button btn;
    protected DatePickerDialog datePickerDialog;

    @Override
    public boolean validateBeforeModelUpdate() {
        return true;
    }

    @Override
    public void updateModel(Document doc) {
        if (this.mode != LayoutMode.VIEW && this.getCurrentValue() != null) {
            doc.set(this.getAttributeName(), ((Calendar)this.getCurrentValue()).getTime());
        }
    }

    @Override
    public void refreshViewFromDocument(Document doc) {
        this.initCurrentValueFromDocument(doc);
        this.applyBinding();
    }

    @Override
    protected void initCurrentValueFromDocument(Document doc) {
        Date date = DocumentAttributeResolver.getDate(doc, this.getAttributeName());
        if (date != null) {
            this.currentValue = Calendar.getInstance();
            ((Calendar)this.currentValue).setTime(date);
        }
    }

    protected void applyBinding() {
        Calendar value = (Calendar)this.getCurrentValue();
        if (value != null) {
            this.txt.setText((CharSequence)fmt.format(value.getTime()));
        } else {
            this.txt.setText((CharSequence)"-- not set --");
        }
        this.txt.invalidate();
    }

    @Override
    public View buildView(LayoutContext context, LayoutMode mode, Document doc, List<String> attributeNames, WidgetDefinition widgetDef) {
        super.buildView(context, mode, doc, attributeNames, widgetDef);
        Activity ctx = context.getActivity();
        this.layout = new LinearLayout((Context)ctx);
        this.layout.setOrientation(0);
        this.txt = new TextView((Context)ctx);
        this.layout.addView((View)this.txt);
        if (mode != LayoutMode.VIEW) {
            this.btn = new Button((Context)ctx);
            this.btn.setBackgroundResource(17301556);
            this.btn.setOnClickListener((View.OnClickListener)this);
            this.layout.addView((View)this.btn);
        }
        this.applyBinding();
        return this.layout;
    }

    public void onClick(View view) {
        Calendar value = (Calendar)this.getCurrentValue();
        if (value == null) {
            value = Calendar.getInstance();
        }
        this.datePickerDialog = new DatePickerDialog(this.getRootContext(), 0, (DatePickerDialog.OnDateSetListener)this, value.get(1), value.get(2), value.get(5));
        this.datePickerDialog.show();
    }

    public void onDateSet(DatePicker dialog, int year, int monthOfYear, int dayOfMonth) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, monthOfYear);
        cal.set(5, dayOfMonth);
        this.currentValue = cal;
        this.applyBinding();
    }
}

