/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.layout.widgets;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.android.layout.LayoutContext;
import org.nuxeo.android.layout.LayoutMode;
import org.nuxeo.android.layout.WidgetDefinition;
import org.nuxeo.android.layout.widgets.AndroidWidgetWrapper;
import org.nuxeo.android.layout.widgets.BaseAndroidWidgetWrapper;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;

public class RichTextWidgetWrapper
extends BaseAndroidWidgetWrapper<List<String>>
implements AndroidWidgetWrapper {
    protected TextView txtWidget;
    protected EditText editWidget;
    protected WebView htmlWidget;
    protected LinearLayout container;

    @Override
    protected void initCurrentValueFromDocument(Document doc) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add(doc.getString(this.getAttributeNames().get(0), ""));
        fields.add(doc.getString(this.getAttributeNames().get(1), "text/plain"));
        this.setCurrentValue(fields);
    }

    protected boolean isHtml() {
        if (((List)this.getCurrentValue()).size() < 2) {
            return false;
        }
        return ((String)((List)this.getCurrentValue()).get(1)).equals("text/html");
    }

    protected void applyBinding() {
        if (this.container != null) {
            if (this.isHtml()) {
                if (this.htmlWidget == null) {
                    this.htmlWidget = new WebView(this.getRootContext());
                    this.container.removeAllViews();
                    this.container.addView((View)this.htmlWidget);
                }
                this.txtWidget = null;
            } else {
                if (this.txtWidget == null) {
                    this.txtWidget = new TextView(this.getRootContext());
                    this.container.removeAllViews();
                    this.container.addView((View)this.txtWidget);
                }
                this.htmlWidget = null;
            }
        }
        if (this.txtWidget != null) {
            this.txtWidget.setText((CharSequence)((List)this.getCurrentValue()).get(0));
        }
        if (this.htmlWidget != null) {
            this.htmlWidget.loadData((String)((List)this.getCurrentValue()).get(0), "text/html", "UTF-8");
        }
        if (this.editWidget != null) {
            this.editWidget.setText((CharSequence)((List)this.getCurrentValue()).get(0));
        }
    }

    @Override
    public View buildView(LayoutContext context, LayoutMode mode, Document doc, List<String> attributeNames, WidgetDefinition widgetDef) {
        super.buildView(context, mode, doc, attributeNames, widgetDef);
        Activity ctx = context.getActivity();
        if (mode == LayoutMode.VIEW) {
            this.container = new LinearLayout((Context)ctx);
            this.container.setOrientation(1);
            this.applyBinding();
            return this.container;
        }
        this.editWidget = new EditText((Context)ctx);
        this.editWidget.setSingleLine(false);
        this.editWidget.setInputType(131073);
        this.editWidget.setLines(3);
        this.editWidget.setGravity(51);
        this.applyBinding();
        return this.editWidget;
    }

    @Override
    public void refreshViewFromDocument(Document doc) {
        this.initCurrentValueFromDocument(doc);
        this.applyBinding();
    }

    @Override
    public void updateModel(Document doc) {
    }

    @Override
    public boolean validateBeforeModelUpdate() {
        return true;
    }
}

