/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.layout.widgets;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import java.util.List;
import org.nuxeo.android.adapters.DocumentAttributeResolver;
import org.nuxeo.android.layout.LayoutContext;
import org.nuxeo.android.layout.LayoutMode;
import org.nuxeo.android.layout.WidgetDefinition;
import org.nuxeo.android.layout.widgets.AndroidWidgetWrapper;
import org.nuxeo.android.layout.widgets.BaseAndroidWidgetWrapper;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyList;

public class SpinnerMultiWidgetWrapper
extends BaseAndroidWidgetWrapper<PropertyList>
implements AndroidWidgetWrapper,
View.OnClickListener {
    protected LinearLayout globalContainer;
    protected LinearLayout valueContainer;
    protected LinearLayout spinnerContainer;
    protected TextView textWidget;
    protected Spinner spinner;
    protected Button spinnerButton;

    @Override
    public boolean validateBeforeModelUpdate() {
        return true;
    }

    @Override
    public void updateModel(Document doc) {
        if (this.mode != LayoutMode.VIEW) {
            DocumentAttributeResolver.put(doc, this.getAttributeName(), this.getCurrentValue());
        }
    }

    @Override
    public void refreshViewFromDocument(Document doc) {
        if (this.mode == LayoutMode.VIEW) {
            this.applyBinding();
        } else {
            this.applyBinding();
        }
    }

    protected void applyBinding() {
        if (this.mode == LayoutMode.VIEW) {
            StringBuffer sb = new StringBuffer();
            if (this.getCurrentValue() != null) {
                for (int i = 0; i < ((PropertyList)this.getCurrentValue()).size(); ++i) {
                    sb.append(this.widgetDef.getSelectOptions().getLabel(((PropertyList)this.getCurrentValue()).getString(i)));
                    sb.append("\n");
                }
                this.textWidget.setText((CharSequence)sb.toString());
            }
            return;
        }
        if (this.getCurrentValue() != null) {
            this.valueContainer.removeAllViews();
            for (int i = 0; i < ((PropertyList)this.getCurrentValue()).size(); ++i) {
                TextView txtWidget = new TextView((Context)this.getHomeActivity());
                txtWidget.setText((CharSequence)this.widgetDef.getSelectOptions().getLabel(((PropertyList)this.getCurrentValue()).getString(i)));
                this.valueContainer.addView((View)txtWidget);
            }
        }
    }

    @Override
    protected void initCurrentValueFromDocument(Document doc) {
        Object val = DocumentAttributeResolver.get(doc, this.getAttributeName());
        if (val instanceof PropertyList) {
            PropertyList value = (PropertyList)val;
            this.setCurrentValue(value);
        } else if (val == null) {
            Log.w((String)this.getClass().getSimpleName(), (String)"Init value from doc = null");
        } else {
            Log.w((String)this.getClass().getSimpleName(), (String)("Init value from doc = " + val.toString()));
        }
    }

    @Override
    public View buildView(LayoutContext context, LayoutMode mode, Document doc, List<String> attributeNames, WidgetDefinition widgetDef) {
        super.buildView(context, mode, doc, attributeNames, widgetDef);
        Activity ctx = context.getActivity();
        LinearLayout.LayoutParams paramsW = new LinearLayout.LayoutParams(-2, -2, 1.0f);
        if (mode == LayoutMode.VIEW) {
            this.textWidget = new TextView((Context)ctx);
            this.textWidget.setSingleLine(false);
            this.textWidget.setInputType(131072);
            this.textWidget.setLines(3);
            this.textWidget.setMaxLines(3);
            this.applyBinding();
            return this.textWidget;
        }
        this.globalContainer = new LinearLayout((Context)ctx);
        this.globalContainer.setOrientation(1);
        this.valueContainer = new LinearLayout((Context)ctx);
        this.valueContainer.setOrientation(1);
        this.spinnerContainer = new LinearLayout((Context)ctx);
        this.spinnerContainer.setOrientation(0);
        this.spinner = new Spinner((Context)ctx);
        this.spinner.setAdapter(this.getAdapter((Context)ctx, widgetDef.getSelectOptions().getItemLabels()));
        this.spinner.setLayoutParams((ViewGroup.LayoutParams)paramsW);
        this.spinnerButton = new Button((Context)ctx);
        this.spinnerButton.setText((CharSequence)"Add");
        this.spinnerButton.setOnClickListener((View.OnClickListener)this);
        this.spinnerButton.setLayoutParams((ViewGroup.LayoutParams)paramsW);
        this.spinnerContainer.addView((View)this.spinner);
        this.spinnerContainer.addView((View)this.spinnerButton);
        this.globalContainer.addView((View)this.valueContainer);
        this.globalContainer.addView((View)this.spinnerContainer);
        this.applyBinding();
        return this.globalContainer;
    }

    protected SpinnerAdapter getAdapter(Context ctx, List<String> opList) {
        ArrayAdapter adapter = new ArrayAdapter(ctx, 17367048, opList);
        adapter.setDropDownViewResource(0x1090009);
        return adapter;
    }

    public void onClick(View arg0) {
        int pos = this.spinner.getSelectedItemPosition();
        String key = this.widgetDef.getSelectOptions().getItemValue(pos);
        PropertyList values = (PropertyList)this.getCurrentValue();
        if (values == null) {
            values = new PropertyList();
        }
        values.add(key);
        this.setCurrentValue(values);
        this.applyBinding();
    }
}

