/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.layout.widgets;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import java.util.List;
import org.nuxeo.android.adapters.DocumentAttributeResolver;
import org.nuxeo.android.layout.LayoutContext;
import org.nuxeo.android.layout.LayoutMode;
import org.nuxeo.android.layout.WidgetDefinition;
import org.nuxeo.android.layout.widgets.AndroidWidgetWrapper;
import org.nuxeo.android.layout.widgets.BaseAndroidWidgetWrapper;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;

public class SpinnerWidgetWrapper
extends BaseAndroidWidgetWrapper<String>
implements AndroidWidgetWrapper {
    protected TextView textWidget;
    protected Spinner spinner;

    @Override
    public boolean validateBeforeModelUpdate() {
        return true;
    }

    @Override
    public void updateModel(Document doc) {
        if (this.mode != LayoutMode.VIEW && this.spinner != null) {
            int pos = this.spinner.getSelectedItemPosition();
            String key = this.widgetDef.getSelectOptions().getItemValue(pos);
            DocumentAttributeResolver.put(doc, this.getAttributeName(), key);
        }
    }

    @Override
    public void refreshViewFromDocument(Document doc) {
        if (this.mode == LayoutMode.VIEW) {
            this.applyBinding();
        } else {
            this.applyBinding();
        }
    }

    protected void applyBinding() {
        if (this.textWidget != null) {
            this.textWidget.setText((CharSequence)this.widgetDef.getSelectOptions().getLabel((String)this.getCurrentValue()));
        } else {
            int idx = this.widgetDef.getSelectOptions().getValueIndex((String)this.getCurrentValue());
            if (idx >= 0) {
                this.spinner.setSelection(idx);
            }
        }
    }

    @Override
    protected void initCurrentValueFromDocument(Document doc) {
        String value = DocumentAttributeResolver.getString(doc, this.getAttributeName());
        this.setCurrentValue(value);
    }

    @Override
    public View buildView(LayoutContext context, LayoutMode mode, Document doc, List<String> attributeNames, WidgetDefinition widgetDef) {
        super.buildView(context, mode, doc, attributeNames, widgetDef);
        Activity ctx = context.getActivity();
        if (mode == LayoutMode.VIEW) {
            this.textWidget = new TextView((Context)ctx);
            this.applyBinding();
            return this.textWidget;
        }
        this.spinner = new Spinner((Context)ctx);
        this.spinner.setAdapter(this.getAdapter((Context)ctx, widgetDef.getSelectOptions().getItemLabels()));
        this.applyBinding();
        return this.spinner;
    }

    protected SpinnerAdapter getAdapter(Context ctx, List<String> opList) {
        ArrayAdapter adapter = new ArrayAdapter(ctx, 17367048, opList);
        adapter.setDropDownViewResource(0x1090009);
        return adapter;
    }
}

