/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.layout.widgets;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import java.util.List;
import org.nuxeo.android.adapters.DocumentAttributeResolver;
import org.nuxeo.android.layout.LayoutContext;
import org.nuxeo.android.layout.LayoutMode;
import org.nuxeo.android.layout.WidgetDefinition;
import org.nuxeo.android.layout.widgets.AndroidWidgetWrapper;
import org.nuxeo.android.layout.widgets.BaseAndroidWidgetWrapper;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;

public class TextAreaWidgetWrapper
extends BaseAndroidWidgetWrapper<String>
implements AndroidWidgetWrapper {
    protected TextView txtWidget;
    protected EditText editWidget;

    @Override
    public boolean validateBeforeModelUpdate() {
        return true;
    }

    @Override
    public void updateModel(Document doc) {
        if (this.editWidget != null && !this.editWidget.getText().toString().equals(this.getCurrentValue())) {
            String value = this.editWidget.getText().toString();
            DocumentAttributeResolver.put(doc, this.getAttributeName(), value);
        }
    }

    @Override
    public void refreshViewFromDocument(Document doc) {
        this.initCurrentValueFromDocument(doc);
        this.applyBinding();
    }

    protected void applyBinding() {
        if (this.txtWidget != null) {
            this.txtWidget.setText((CharSequence)this.getCurrentValue());
        }
        if (this.editWidget != null) {
            this.editWidget.setText((CharSequence)this.getCurrentValue());
        }
    }

    @Override
    public View buildView(LayoutContext context, LayoutMode mode, Document doc, List<String> attributeNames, WidgetDefinition widgetDef) {
        super.buildView(context, mode, doc, attributeNames, widgetDef);
        Activity ctx = context.getActivity();
        TextView view = null;
        if (mode == LayoutMode.VIEW) {
            this.txtWidget = new TextView((Context)ctx);
            this.txtWidget.setSingleLine(false);
            this.txtWidget.setLines(3);
            this.txtWidget.setGravity(51);
            view = this.txtWidget;
        } else {
            this.editWidget = new EditText((Context)ctx);
            this.editWidget.setSingleLine(false);
            this.editWidget.setInputType(131073);
            this.editWidget.setLines(3);
            this.editWidget.setGravity(51);
            view = this.editWidget;
        }
        this.applyBinding();
        return view;
    }

    @Override
    protected void initCurrentValueFromDocument(Document doc) {
        this.setCurrentValue(DocumentAttributeResolver.getString(doc, this.getAttributeName()));
    }
}

