/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.network;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Bundle;
import org.nuxeo.android.network.NuxeoNetworkStatus;

public class NetworkStatusBroadCastReceiver
extends BroadcastReceiver {
    protected final NuxeoNetworkStatus networkStatus;

    public NetworkStatusBroadCastReceiver(NuxeoNetworkStatus offlineSettings) {
        this.networkStatus = offlineSettings;
    }

    public void onReceive(Context ctx, Intent intent) {
        if (intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) {
            Bundle bundle = intent.getExtras();
            if (bundle.getBoolean("noConnectivity")) {
                this.networkStatus.setNetworkReachable(false);
            } else {
                String reason = bundle.getString("reason");
                boolean isFailover = bundle.getBoolean("isFailover", false);
                NetworkInfo currentNetworkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                NetworkInfo otherNetworkInfo = (NetworkInfo)intent.getParcelableExtra("otherNetwork");
                boolean connectivityOk = this.isNetworkUsable(currentNetworkInfo);
                if (!connectivityOk && otherNetworkInfo != null) {
                    connectivityOk = this.isNetworkUsable(otherNetworkInfo);
                }
                if (!connectivityOk) {
                    this.networkStatus.setNetworkReachable(false);
                } else {
                    this.networkStatus.setNetworkReachable(true);
                    new AsyncTask<Void, Void, Void>(){

                        protected Void doInBackground(Void ... params) {
                            NetworkStatusBroadCastReceiver.this.networkStatus.testNuxeoServerReachable();
                            return null;
                        }
                    };
                }
            }
        }
    }

    protected boolean isNetworkUsable(NetworkInfo networkInfo) {
        int type = networkInfo.getType();
        if (type == 2) {
            return false;
        }
        if (type == 3) {
            return false;
        }
        return networkInfo.getState() == NetworkInfo.State.CONNECTED;
    }
}

