/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.network;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import java.net.HttpURLConnection;
import java.net.URL;
import org.nuxeo.android.config.NuxeoServerConfig;

public class NuxeoNetworkStatus
extends BroadcastReceiver {
    private static final String TAG = "NuxeoNetworkStatus";
    protected final NuxeoServerConfig serverConfig;
    protected final ConnectivityManager cm;
    protected boolean forceOffline = false;
    protected boolean networkReachable = true;
    protected boolean nuxeoServerReachable = true;
    protected final Context androidContext;

    public NuxeoNetworkStatus(Context androidContext, NuxeoServerConfig serverConfig, ConnectivityManager cm) {
        this.androidContext = androidContext;
        this.serverConfig = serverConfig;
        this.cm = cm;
        androidContext.registerReceiver((BroadcastReceiver)this, new IntentFilter("NuxeoSettingsChanged"));
        this.resetAsync();
    }

    public void resetAsync() {
        Runnable tester = new Runnable(){

            @Override
            public void run() {
                NuxeoNetworkStatus.this.reset();
            }
        };
        new Thread(tester).start();
    }

    public void reset() {
        boolean hasNetwork = false;
        for (NetworkInfo netInfo : this.cm.getAllNetworkInfo()) {
            int type;
            if (netInfo.getState() != NetworkInfo.State.CONNECTED || (type = netInfo.getType()) == 3 && type == 2) continue;
            hasNetwork = true;
            break;
        }
        if (hasNetwork) {
            this.networkReachable = true;
            this.testNuxeoServerReachable();
        } else {
            Log.d((String)TAG, (String)"No network");
        }
    }

    public boolean isForceOffline() {
        return this.forceOffline;
    }

    public void setForceOffline(boolean forceOffline) {
        boolean recheck = this.forceOffline && !forceOffline;
        this.forceOffline = forceOffline;
        if (recheck) {
            this.resetAsync();
        }
    }

    public boolean isNetworkReachable() {
        return this.networkReachable;
    }

    public void setNetworkReachable(boolean networkReachable) {
        if (this.networkReachable != networkReachable) {
            this.networkReachable = networkReachable;
            if (!networkReachable) {
                this.setNuxeoServerReachable(false);
            }
            this.notifyChanged();
            Log.d((String)TAG, (String)("Connectivity changed: networkReachable=" + networkReachable));
        }
    }

    public boolean canUseNetwork() {
        return this.networkReachable && this.nuxeoServerReachable && !this.forceOffline;
    }

    public boolean isNuxeoServerReachable() {
        return this.nuxeoServerReachable;
    }

    public void setNuxeoServerReachable(boolean nuxeoServerReachable) {
        if (this.nuxeoServerReachable != nuxeoServerReachable) {
            this.nuxeoServerReachable = nuxeoServerReachable;
            Log.d((String)TAG, (String)("Connectivity changed: nuxeoServerReachable=" + nuxeoServerReachable));
            this.notifyChanged();
        }
    }

    public NuxeoServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public boolean testNuxeoServerReachable() {
        this.setNuxeoServerReachable(this.pingNuxeoServer());
        return this.isNuxeoServerReachable();
    }

    protected boolean pingNuxeoServer() {
        try {
            URL url = new URL(this.getServerConfig().getServerBaseUrl() + "login.jsp");
            HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
            urlc.setRequestProperty("User-Agent", "Nuxeo Android Application");
            urlc.setRequestProperty("Connection", "close");
            urlc.setConnectTimeout(15000);
            urlc.connect();
            return urlc.getResponseCode() == 200;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Connection to Nuxeo server failed: " + e.getMessage()));
            Log.d((String)TAG, (String)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void notifyChanged() {
        this.androidContext.sendBroadcast(new Intent("NuxeoServerConnectivityChanged"));
    }

    public void onReceive(Context ctx, Intent intent) {
        if (intent.getAction().equals("NuxeoSettingsChanged")) {
            this.resetAsync();
        }
    }
}

