/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.repository;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.Session;
import org.nuxeo.ecm.automation.client.jaxrs.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.jaxrs.model.Blob;
import org.nuxeo.ecm.automation.client.jaxrs.model.DocRef;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;
import org.nuxeo.ecm.automation.client.jaxrs.model.Documents;

public class DocumentManager
extends DocumentService {
    public DocumentManager(Session session) {
        super(session);
    }

    public Document getDocument(DocRef docRef, boolean refresh) throws Exception {
        OperationRequest fetchOperation = this.session.newRequest("Document.Fetch").set("value", docRef);
        fetchOperation.setHeader("X-NXDocumentProperties", "*");
        byte cacheFlag = 1;
        if (refresh) {
            cacheFlag = (byte)(cacheFlag | 2);
        }
        return (Document)fetchOperation.execute(cacheFlag);
    }

    public Documents query(String nxql, String[] queryParams, String[] sortInfo, String schemaList, int page, int pageSize, byte cacheFlags) throws Exception {
        nxql = nxql.replaceAll("'", "\"");
        OperationRequest fetchOperation = this.session.newRequest("Document.PageProvider").set("query", nxql).set("pageSize", pageSize).set("page", 0);
        if (queryParams != null) {
            fetchOperation.set("queryParams", queryParams);
        }
        if (sortInfo != null) {
            fetchOperation.set("sortInfo", sortInfo);
        }
        if (schemaList == null) {
            schemaList = "common,dublincore";
        }
        fetchOperation.setHeader("X-NXDocumentProperties", schemaList);
        Documents docs = (Documents)fetchOperation.execute(cacheFlags);
        return docs;
    }

    public Document getUserHome() throws Exception {
        return (Document)this.session.newRequest("UserWorkspace.Get").execute();
    }

    public List<JSONObject> getAuditEntriesForDocument(String docId, boolean refresh) throws Exception {
        byte cacheFlag = 1;
        if (refresh) {
            cacheFlag = (byte)(cacheFlag | 2);
        }
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        String auditQuery = "from LogEntry log WHERE log.docUUID = '" + docId + "'" + "   AND log.docLifeCycle IS NOT NULL" + "   AND log.docLifeCycle <> 'undefined'" + " ORDER BY log.eventDate DESC";
        Blob blob = (Blob)this.session.newRequest("Audit.Query").set("query", auditQuery).set("maxResults", 5).execute(cacheFlag);
        if (blob != null) {
            String jsonData = this.readBlobAsString(blob);
            JSONArray array = new JSONArray(jsonData);
            for (int i = 0; i < array.length(); ++i) {
                result.add(array.getJSONObject(i));
            }
        }
        return result;
    }

    public List<JSONObject> getUserTasks(boolean refresh) throws Exception {
        byte cacheFlag = 1;
        if (refresh) {
            cacheFlag = (byte)(cacheFlag | 2);
        }
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        Blob blob = (Blob)this.getSession().newRequest("Workflow.GetTask").execute(cacheFlag);
        if (blob != null) {
            String jsonData = this.readBlobAsString(blob);
            JSONArray array = new JSONArray(jsonData);
            for (int i = 0; i < array.length(); ++i) {
                result.add(array.getJSONObject(i));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readBlobAsString(Blob blob) throws Exception {
        StringBuffer sb = new StringBuffer();
        BufferedReader blobReader = null;
        try {
            String line;
            blobReader = new BufferedReader(new InputStreamReader(blob.getStream()));
            while ((line = blobReader.readLine()) != null) {
                sb.append(line);
            }
        }
        finally {
            if (blobReader != null) {
                try {
                    blobReader.close();
                }
                catch (IOException e) {}
            }
        }
        return sb.toString();
    }
}

