/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.upload;

import android.util.Log;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.nuxeo.android.cache.blob.BlobStore;
import org.nuxeo.android.cache.blob.BlobWithProperties;
import org.nuxeo.android.upload.RepeatableBlobEntityWithProgress;
import org.nuxeo.ecm.automation.client.android.AndroidAutomationClient;
import org.nuxeo.ecm.automation.client.android.UIAsyncCallback;
import org.nuxeo.ecm.automation.client.jaxrs.AsyncCallback;
import org.nuxeo.ecm.automation.client.jaxrs.model.Blob;

public class FileUploader {
    public static final String UPLOAD_UUID = "uuid";
    public static final String FILE_ID = "fileId";
    public static final String BATCH_ID = "batchId";
    protected final BlobStore store;
    protected final AndroidAutomationClient client;
    protected LinkedList<String> uploadDone = new LinkedList();
    protected final CopyOnWriteArrayList<String> uploadInProgress = new CopyOnWriteArrayList();

    public FileUploader(AndroidAutomationClient client) {
        this.store = client.getBlobStoreManager().getBlobStore("upload");
        this.client = client;
    }

    public BlobWithProperties storeAndUpload(String batchId, String fileId, Blob blob, AsyncCallback<Serializable> cb) {
        BlobWithProperties res = this.storeFileForUpload(batchId, fileId, blob);
        this.startUpload(batchId, fileId, res, cb);
        return res;
    }

    public void startUpload(String key, AsyncCallback<Serializable> cb) {
        if (this.uploadInProgress.addIfAbsent(key)) {
            BlobWithProperties blob = this.store.getBlob(key);
            String batchId = blob.getProperty(BATCH_ID);
            String fileId = blob.getProperty(FILE_ID);
            this.startUpload(batchId, fileId, blob, cb);
        }
    }

    protected void startUpload(final String batchId, final String fileId, final BlobWithProperties blob, final AsyncCallback<Serializable> cb) {
        this.client.asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Log.i((String)FileUploader.class.getSimpleName(), (String)("Starting upload for Blob with UUID" + blob.getProperty(FileUploader.UPLOAD_UUID)));
                String url = FileUploader.this.client.getServerConfig().getServerBaseUrl() + "site/automation/batch/upload";
                HttpPost post = new HttpPost(url);
                post.setHeader("Cache-Control", "no-cache");
                post.setHeader("X-File-Name", blob.getFileName());
                post.setHeader("X-File-Size", blob.getLength() + "");
                post.setHeader("X-File-Type", blob.getMimeType());
                post.setHeader("X-Batch-Id", batchId);
                post.setHeader("X-File-Idx", fileId);
                try {
                    RepeatableBlobEntityWithProgress blobEntity = null;
                    if (cb != null && cb instanceof UIAsyncCallback) {
                        blobEntity = new RepeatableBlobEntityWithProgress(blob, (UIAsyncCallback)cb);
                        ((UIAsyncCallback)cb).notifyStart();
                    } else {
                        blobEntity = new RepeatableBlobEntityWithProgress(blob, null);
                    }
                    post.setEntity((HttpEntity)blobEntity);
                    HttpResponse response = FileUploader.this.client.getConnector().executeSimpleHttp((HttpUriRequest)post);
                    if (response.getStatusLine().getStatusCode() == 200) {
                        Log.i((String)FileUploader.class.getSimpleName(), (String)("Upload completed successfuly for Blob with UUID" + blob.getProperty(FileUploader.UPLOAD_UUID)));
                        Log.i((String)FileUploader.class.getSimpleName(), (String)("removing Blob with UUID" + blob.getProperty(FileUploader.UPLOAD_UUID)));
                        FileUploader.this.removeBlob(blob);
                        if (cb != null) {
                            cb.onSuccess(batchId, response.getStatusLine().getReasonPhrase());
                        }
                    } else {
                        if (cb != null) {
                            cb.onError(batchId, new Exception("Server returned status code " + response.getStatusLine().getStatusCode()));
                        }
                        Log.e((String)FileUploader.class.getSimpleName(), (String)("Server returned status code " + response.getStatusLine().getStatusCode()));
                    }
                }
                catch (Exception e) {
                    if (cb != null) {
                        cb.onError(batchId, e);
                    }
                    Log.e((String)FileUploader.class.getSimpleName(), (String)"Exception during upload", (Throwable)e);
                }
                finally {
                    FileUploader.this.uploadInProgress.remove(blob.getProperty(FileUploader.UPLOAD_UUID));
                }
            }
        });
    }

    public BlobWithProperties storeFileForUpload(String batchId, String fileId, Blob blob) {
        String key = UUID.randomUUID().toString();
        Properties props = new Properties();
        props.put(BATCH_ID, batchId);
        props.put(FILE_ID, fileId);
        props.put(UPLOAD_UUID, key);
        return this.store.storeBlob(key, blob, props);
    }

    protected void removeBlob(BlobWithProperties blob) {
        this.store.deleteBlob(blob.getProperty(UPLOAD_UUID));
    }

    public BlobWithProperties getBlob(String key) {
        return this.store.getBlob(key);
    }

    public void cancelUpload(String batchId) {
    }

    public boolean isUploadDone(String key) {
        if (this.uploadDone.contains(key)) {
            return true;
        }
        for (Properties props : this.store) {
            String uuid = props.getProperty(UPLOAD_UUID);
            if (uuid == null || !uuid.equals(key)) continue;
            return false;
        }
        this.uploadDone.addLast(key);
        if (this.uploadDone.size() > 20) {
            this.uploadDone.removeFirst();
        }
        return true;
    }

    public long getPendingUploadCount() {
        return this.store.getCount();
    }

    public void purgePendingUploads() {
        this.store.clear();
    }
}

