/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.upload;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.nuxeo.ecm.automation.client.android.UIAsyncCallback;

public class InputStreamWithProgress
extends InputStream {
    protected final InputStream is;
    protected int length;
    protected int sent;
    protected UIAsyncCallback<Serializable> cb;

    public InputStreamWithProgress(InputStream is, int length, UIAsyncCallback<Serializable> cb) {
        this.is = is;
        this.length = length;
        this.cb = cb;
        this.sent = 0;
    }

    protected int notifyUpdate(int readSize) {
        if (this.cb != null) {
            this.sent += readSize;
            Float progress = Float.valueOf(100.0f * ((float)this.sent / (float)this.length));
            this.cb.notifyProgressChange(progress.intValue());
        }
        return readSize;
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.notifyUpdate(this.is.read(b, off, len));
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.notifyUpdate(this.is.read(b));
    }

    @Override
    public int read() throws IOException {
        return this.notifyUpdate(this.is.read());
    }
}

