/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.android.upload;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.http.entity.AbstractHttpEntity;
import org.nuxeo.android.upload.InputStreamWithProgress;
import org.nuxeo.ecm.automation.client.android.UIAsyncCallback;
import org.nuxeo.ecm.automation.client.jaxrs.model.Blob;

public class RepeatableBlobEntityWithProgress
extends AbstractHttpEntity {
    protected static final int BUFFER_SIZE = 2048;
    protected Blob blob;
    protected UIAsyncCallback<Serializable> cb;

    public RepeatableBlobEntityWithProgress(Blob blob, UIAsyncCallback<Serializable> cb) {
        this.blob = blob;
        this.cb = cb;
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        return new InputStreamWithProgress(this.blob.getStream(), this.blob.getLength(), this.cb);
    }

    public long getContentLength() {
        return this.blob.getLength();
    }

    public boolean isRepeatable() {
        return true;
    }

    public boolean isStreaming() {
        return true;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        int l;
        if (outstream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        InputStream instream = this.getContent();
        byte[] buffer = new byte[2048];
        for (long remaining = (long)this.blob.getLength(); remaining > 0L && (l = instream.read(buffer, 0, (int)Math.min(2048L, remaining))) != -1; remaining -= (long)l) {
            outstream.write(buffer, 0, l);
        }
    }
}

