/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.android;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.net.http.AndroidHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.nuxeo.android.cache.blob.BlobStoreManager;
import org.nuxeo.android.cache.sql.SQLStateManager;
import org.nuxeo.android.config.NuxeoServerConfig;
import org.nuxeo.android.documentprovider.AndroidDocumentProvider;
import org.nuxeo.android.documentprovider.DocumentProvider;
import org.nuxeo.android.download.FileDownloader;
import org.nuxeo.android.layout.AndroidLayoutService;
import org.nuxeo.android.layout.NuxeoLayoutService;
import org.nuxeo.android.network.NuxeoNetworkStatus;
import org.nuxeo.android.repository.DocumentManager;
import org.nuxeo.android.upload.FileUploader;
import org.nuxeo.ecm.automation.client.android.AndroidDeferredUpdateManager;
import org.nuxeo.ecm.automation.client.android.AndroidMessageHelper;
import org.nuxeo.ecm.automation.client.android.AndroidResponseCacheManager;
import org.nuxeo.ecm.automation.client.android.AndroidTransientStateManager;
import org.nuxeo.ecm.automation.client.android.CachedSession;
import org.nuxeo.ecm.automation.client.android.SessionCache;
import org.nuxeo.ecm.automation.client.broadcast.DocumentMessageService;
import org.nuxeo.ecm.automation.client.cache.CachedHttpConnector;
import org.nuxeo.ecm.automation.client.cache.DeferredUpdateManager;
import org.nuxeo.ecm.automation.client.cache.OperationType;
import org.nuxeo.ecm.automation.client.cache.ResponseCacheManager;
import org.nuxeo.ecm.automation.client.cache.TransientStateManager;
import org.nuxeo.ecm.automation.client.jaxrs.AsyncCallback;
import org.nuxeo.ecm.automation.client.jaxrs.LoginInfo;
import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.Session;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpAutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Connector;

public class AndroidAutomationClient
extends HttpAutomationClient {
    private static final String TAG = "AndroidAutomationClient";
    protected final ResponseCacheManager responseCacheManager;
    protected final DeferredUpdateManager deferredUpdatetManager;
    protected final AndroidTransientStateManager transientStateManager;
    protected final NuxeoNetworkStatus networkStatus;
    protected final DocumentMessageService messageHelper;
    protected final SQLStateManager sqlStateManager;
    protected final BlobStoreManager blobStoreManager;
    protected final DocumentProvider documentProvider;
    protected final Context androidContext;
    protected final FileDownloader fileDownloader;
    protected final NuxeoServerConfig serverConfig;
    protected final FileUploader fileUploader;
    protected final NuxeoLayoutService layoutService;
    protected SessionCache sessionCache;
    protected Session currentSession;

    public AndroidAutomationClient(String url, Context androidContext, SQLStateManager sqlStateManager, BlobStoreManager blobStoreManager, NuxeoNetworkStatus offlineSettings, NuxeoServerConfig serverConfig) {
        super(url);
        this.http.getConnectionManager().shutdown();
        this.http = AndroidHttpClient.newInstance((String)"Nuxeo Android Client", (Context)androidContext);
        HttpProtocolParams.setUseExpectContinue((HttpParams)this.http.getParams(), (boolean)false);
        this.sqlStateManager = sqlStateManager;
        this.blobStoreManager = blobStoreManager;
        this.responseCacheManager = new AndroidResponseCacheManager(sqlStateManager, blobStoreManager);
        this.deferredUpdatetManager = new AndroidDeferredUpdateManager(sqlStateManager);
        this.networkStatus = offlineSettings;
        this.androidContext = androidContext;
        this.messageHelper = new AndroidMessageHelper(androidContext);
        this.transientStateManager = new AndroidTransientStateManager(androidContext, sqlStateManager);
        this.documentProvider = new AndroidDocumentProvider(sqlStateManager);
        this.fileDownloader = new FileDownloader(this);
        this.serverConfig = serverConfig;
        this.fileUploader = new FileUploader(this);
        this.layoutService = new AndroidLayoutService(this.fileDownloader);
        this.sessionCache = new SessionCache();
        this.setBasicAuth(serverConfig.getLogin(), serverConfig.getPassword());
    }

    public void dropCurrentSession() {
        this.currentSession = null;
    }

    @Override
    protected Connector newConnector() {
        CachedHttpConnector con = new CachedHttpConnector(this.http, this.responseCacheManager, this.networkStatus);
        return con;
    }

    @Override
    public boolean isOffline() {
        return !this.networkStatus.canUseNetwork();
    }

    @Override
    public String execDeferredUpdate(OperationRequest request, AsyncCallback<Object> cb, OperationType opType) {
        if (this.deferredUpdatetManager != null) {
            boolean executeNow = this.networkStatus.canUseNetwork();
            return this.deferredUpdatetManager.execDeferredUpdate(request, cb, opType, executeNow);
        }
        throw new UnsupportedOperationException("No DeferredUpdateManager defined");
    }

    public ResponseCacheManager getResponseCacheManager() {
        return this.responseCacheManager;
    }

    public DeferredUpdateManager getDeferredUpdatetManager() {
        return this.deferredUpdatetManager;
    }

    public NuxeoNetworkStatus getNetworkStatus() {
        return this.networkStatus;
    }

    @Override
    public DocumentMessageService getMessageHelper() {
        return this.messageHelper;
    }

    public SQLStateManager getSqlStateManager() {
        return this.sqlStateManager;
    }

    public TransientStateManager getTransientStateManager() {
        return this.transientStateManager;
    }

    public DocumentProvider getDocumentProvider() {
        return this.documentProvider;
    }

    public BlobStoreManager getBlobStoreManager() {
        return this.blobStoreManager;
    }

    public FileDownloader getFileDownloader() {
        return this.fileDownloader;
    }

    public NuxeoServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public Context getAndroidContext() {
        return this.androidContext;
    }

    public FileUploader getFileUploader() {
        return this.fileUploader;
    }

    public NuxeoLayoutService getLayoutService() {
        return this.layoutService;
    }

    @Override
    public <T> T getAdapter(Object objToAdapt, Class<T> adapterType) {
        if (adapterType.getName().equals(NuxeoLayoutService.class.getName())) {
            return adapterType.cast(this.layoutService);
        }
        if (adapterType.getName().equals(FileDownloader.class.getName())) {
            return adapterType.cast(this.fileDownloader);
        }
        if (adapterType.getName().equals(FileUploader.class.getName())) {
            return adapterType.cast(this.fileUploader);
        }
        if (adapterType.getName().equals(TransientStateManager.class.getName())) {
            return adapterType.cast(this.transientStateManager);
        }
        if (adapterType.getName().equals(DeferredUpdateManager.class.getName())) {
            return adapterType.cast(this.deferredUpdatetManager);
        }
        if (adapterType.getName().equals(BlobStoreManager.class.getName())) {
            return adapterType.cast(this.blobStoreManager);
        }
        if (adapterType.getName().equals(ResponseCacheManager.class.getName())) {
            return adapterType.cast(this.responseCacheManager);
        }
        if (adapterType.getName().equals(DocumentMessageService.class.getName())) {
            return adapterType.cast(this.messageHelper);
        }
        if (adapterType.getName().equals(DocumentProvider.class.getName())) {
            return adapterType.cast(this.documentProvider);
        }
        if (adapterType.getName().equals(DocumentManager.class.getName())) {
            return adapterType.cast(new DocumentManager((Session)objToAdapt));
        }
        return super.getAdapter(objToAdapt, adapterType);
    }

    @Override
    @Deprecated
    public Session getSession(String username, String password) {
        return this.getSession();
    }

    @Override
    public Session getSession() {
        LoginInfo li;
        if (this.currentSession != null && (li = this.currentSession.getLogin()) != null && li.getUsername().equals(this.serverConfig.getLogin())) {
            return this.currentSession;
        }
        CachedSession session = this.sessionCache.getCachedSession(this, this.url, this.serverConfig.getLogin(), this.serverConfig.getCacheKey());
        if (session != null) {
            this.registry = session.getOperationRegistry();
            this.currentSession = session;
            this.async.submit(new Runnable(){

                @Override
                public void run() {
                    Session liveSession;
                    if (AndroidAutomationClient.this.networkStatus.isNuxeoServerReachable() && (liveSession = AndroidAutomationClient.this.createSession()) != null) {
                        AndroidAutomationClient.this.currentSession = liveSession;
                    }
                }
            });
            return session;
        }
        this.currentSession = this.createSession();
        if (this.currentSession != null) {
            this.sessionCache.storeSession(this, this.url, this.serverConfig.getLogin(), this.serverConfig.getCacheKey());
        }
        return this.currentSession;
    }

    @Deprecated
    protected Session createSession(String username, String password) {
        return super.getSession(username, password);
    }

    protected Session createSession() {
        return super.getSession();
    }

    public String toString() {
        return "URL=" + this.url + " network usable=" + this.networkStatus.canUseNetwork();
    }

    @Override
    public synchronized void shutdown() {
        super.shutdown();
        if (this.http != null) {
            ((AndroidHttpClient)this.http).close();
        }
        try {
            this.androidContext.unregisterReceiver((BroadcastReceiver)this.transientStateManager);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

