/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.android;

import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.android.cache.sql.DeferedUpdateTableWrapper;
import org.nuxeo.android.cache.sql.SQLStateManager;
import org.nuxeo.ecm.automation.client.android.AndroidAutomationClient;
import org.nuxeo.ecm.automation.client.broadcast.DocumentMessageService;
import org.nuxeo.ecm.automation.client.broadcast.EventLifeCycle;
import org.nuxeo.ecm.automation.client.cache.CachedOperationRequest;
import org.nuxeo.ecm.automation.client.cache.DeferredUpdateManager;
import org.nuxeo.ecm.automation.client.cache.OperationType;
import org.nuxeo.ecm.automation.client.jaxrs.AsyncCallback;
import org.nuxeo.ecm.automation.client.jaxrs.Dependency;
import org.nuxeo.ecm.automation.client.jaxrs.ExecutionDependencies;
import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.Session;
import org.nuxeo.ecm.automation.client.jaxrs.impl.CacheKeyHelper;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;

public class AndroidDeferredUpdateManager
implements DeferredUpdateManager {
    protected ConcurrentHashMap<String, AsyncCallback<Object>> pendingCallbacks = new ConcurrentHashMap();
    protected final SQLStateManager sqlStateManager;

    public AndroidDeferredUpdateManager(SQLStateManager sqlStateManager) {
        this.sqlStateManager = sqlStateManager;
        sqlStateManager.registerWrapper(new DeferedUpdateTableWrapper());
    }

    protected DeferedUpdateTableWrapper getTableWrapper() {
        return (DeferedUpdateTableWrapper)this.sqlStateManager.getTableWrapper("NuxeoPendingUpdates");
    }

    @Override
    public void deleteDeferredUpdate(String key) {
        this.getTableWrapper().deleteEntry(key);
    }

    @Override
    public String execDeferredUpdate(OperationRequest request, AsyncCallback<Object> cb, final OperationType opType, boolean exeuteNow) {
        final String requestKey = CacheKeyHelper.computeRequestKey(request);
        this.pendingCallbacks.put(requestKey, cb);
        request = this.storePendingRequest(requestKey, request, opType);
        final DocumentMessageService messageHelper = request.getSession().getMessageHelper();
        boolean depOk = !request.hasDependencies();
        Log.i((String)this.getClass().getSimpleName(), (String)"Request has dependencies ... checking resolution ");
        if (!depOk) {
            depOk = this.checkDependencies(request);
        }
        if (depOk) {
            Log.i((String)this.getClass().getSimpleName(), (String)"Dependencies resolved");
        } else {
            Log.i((String)this.getClass().getSimpleName(), (String)"There are still pending dependencies, update will have to wait. ");
        }
        if (exeuteNow && depOk) {
            request.execute(new AsyncCallback<Object>(){

                @Override
                public void onError(String executionId, Throwable e) {
                    Log.e((String)AndroidDeferredUpdateManager.class.getSimpleName(), (String)"Failed to execute deferred op", (Throwable)e);
                    AsyncCallback<Object> clientCB = AndroidDeferredUpdateManager.this.pendingCallbacks.remove(requestKey);
                    if (clientCB != null) {
                        clientCB.onError(requestKey, e);
                    }
                    Bundle extra = new Bundle();
                    extra.putString("RequestId", executionId);
                    messageHelper.notifyDocumentOperation(null, opType, EventLifeCycle.FAILED, extra);
                }

                @Override
                public void onSuccess(String executionId, Object data) {
                    Log.i((String)AndroidDeferredUpdateManager.class.getSimpleName(), (String)("Execute deferred op " + executionId));
                    AndroidDeferredUpdateManager.this.deleteDeferredUpdate(requestKey);
                    AsyncCallback<Object> clientCB = AndroidDeferredUpdateManager.this.pendingCallbacks.remove(requestKey);
                    Document doc = null;
                    if (data != null && data instanceof Document) {
                        doc = (Document)data;
                    }
                    Bundle extra = new Bundle();
                    extra.putString("RequestId", executionId);
                    messageHelper.notifyDocumentOperation(doc, opType, EventLifeCycle.SERVER, extra);
                    if (clientCB != null) {
                        Log.i((String)AndroidDeferredUpdateManager.class.getSimpleName(), (String)"Call onSuccess client CB");
                        clientCB.onSuccess(requestKey, data);
                    }
                }
            }, (byte)2);
        }
        return requestKey;
    }

    protected AndroidAutomationClient getClient(Session session) {
        return (AndroidAutomationClient)session.getClient();
    }

    protected boolean checkDependencies(final CachedOperationRequest request) {
        AsyncCallback<Serializable> cb = new AsyncCallback<Serializable>(){

            @Override
            public void onError(String executionId, Throwable e) {
            }

            @Override
            public void onSuccess(String executionId, Serializable data) {
                AndroidDeferredUpdateManager.this.executePendingRequests(request, null);
            }
        };
        return this.checkDependencies(this.getClient(request.getRequest().getSession()), request.getRequest().getDependencies(), cb);
    }

    protected boolean checkDependencies(OperationRequest request) {
        return this.checkDependencies(this.getClient(request.getSession()), request.getDependencies(), null);
    }

    protected boolean checkDependencies(AndroidAutomationClient client, ExecutionDependencies dependencies, AsyncCallback<Serializable> cb) {
        Log.i((String)this.getClass().getSimpleName(), (String)("Checking : " + dependencies.size() + " dependencies"));
        for (Dependency dep : dependencies) {
            if (dep.getType() != Dependency.DependencyType.FILE_UPLOAD) continue;
            Log.i((String)this.getClass().getSimpleName(), (String)("Found dependency : " + dep.getToken()));
            if (client.getFileUploader().isUploadDone(dep.getToken())) {
                Log.i((String)this.getClass().getSimpleName(), (String)("Dependency resolved : " + dep.getToken()));
                dependencies.markAsResolved(dep.getToken());
                continue;
            }
            Log.i((String)this.getClass().getSimpleName(), (String)("Dependency NOT resolved : " + dep.getToken()));
            if (client.isOffline() || cb == null) continue;
            client.getFileUploader().startUpload(dep.getToken(), cb);
        }
        return dependencies.resolved();
    }

    protected OperationRequest storePendingRequest(String requestKey, OperationRequest request, OperationType opType) {
        return this.getTableWrapper().storeRequest(requestKey, request, opType);
    }

    protected List<CachedOperationRequest> getPendingRequest(Session session) {
        return this.getTableWrapper().getPendingRequests(session);
    }

    @Override
    public void executePendingRequests(Session session) {
        this.executePendingRequests(session, null);
    }

    @Override
    public void executePendingRequests(Session session, Handler uiNotifier) {
        List<CachedOperationRequest> cachedRequests = this.getPendingRequest(session);
        this.executePendingRequests(session, cachedRequests, uiNotifier);
    }

    public void executePendingRequests(CachedOperationRequest cachedRequest, Handler uiNotifier) {
        ArrayList<CachedOperationRequest> cachedRequests = new ArrayList<CachedOperationRequest>();
        cachedRequests.add(cachedRequest);
        this.executePendingRequests(cachedRequest.getRequest().getSession(), cachedRequests, uiNotifier);
    }

    public void executePendingRequests(Session session, List<CachedOperationRequest> cachedRequests, final Handler uiNotifier) {
        final DocumentMessageService messageHelper = session.getMessageHelper();
        for (CachedOperationRequest op : this.getPendingRequest(session)) {
            OperationRequest request = op.getRequest();
            if (!this.checkDependencies(op)) {
                Log.i((String)this.getClass().getSimpleName(), (String)"Skipping operation because dependencies are not resolved");
                continue;
            }
            final String requestKey = op.getOperationKey();
            final OperationType opType = op.getOpType();
            request.execute(new AsyncCallback<Object>(){

                @Override
                public void onError(String executionId, Throwable e) {
                    AsyncCallback<Object> clientCB = AndroidDeferredUpdateManager.this.pendingCallbacks.remove(requestKey);
                    if (clientCB != null) {
                        clientCB.onError(requestKey, e);
                    }
                    if (uiNotifier != null) {
                        uiNotifier.sendEmptyMessage(0);
                    }
                    Bundle extra = new Bundle();
                    extra.putString("RequestId", executionId);
                    messageHelper.notifyDocumentOperation(null, opType, EventLifeCycle.FAILED, extra);
                }

                @Override
                public void onSuccess(String executionId, Object data) {
                    AndroidDeferredUpdateManager.this.deleteDeferredUpdate(requestKey);
                    AsyncCallback<Object> clientCB = AndroidDeferredUpdateManager.this.pendingCallbacks.remove(requestKey);
                    if (clientCB != null) {
                        clientCB.onSuccess(requestKey, data);
                    }
                    if (uiNotifier != null) {
                        uiNotifier.sendEmptyMessage(0);
                    }
                    Document doc = null;
                    if (data != null && data instanceof Document) {
                        doc = (Document)data;
                    }
                    Bundle extra = new Bundle();
                    extra.putString("RequestId", executionId);
                    messageHelper.notifyDocumentOperation(doc, opType, EventLifeCycle.SERVER, extra);
                }
            }, (byte)2);
        }
    }

    @Override
    public long getPendingRequestCount() {
        return this.getTableWrapper().getCount();
    }

    @Override
    public void purgePendingUpdates() {
        this.getTableWrapper().clearTable();
    }
}

