/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.android;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import java.io.Serializable;
import org.nuxeo.ecm.automation.client.broadcast.DocumentMessageService;
import org.nuxeo.ecm.automation.client.broadcast.EventLifeCycle;
import org.nuxeo.ecm.automation.client.cache.OperationType;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;

public class AndroidMessageHelper
implements DocumentMessageService {
    protected final Context ctx;

    public AndroidMessageHelper(Context androidContext) {
        this.ctx = androidContext;
    }

    @Override
    public void notifyDocumentOperation(Document doc, OperationType opType, EventLifeCycle state, Bundle extra) {
        if (opType == OperationType.CREATE) {
            this.notifyDocumentCreated(doc, state, extra);
        } else if (opType == OperationType.UPDATE) {
            this.notifyDocumentUpdated(doc, state, extra);
        } else if (opType == OperationType.DELETE) {
            this.notifyDocumentDeleted(doc, state, extra);
        }
    }

    @Override
    public void notifyDocumentCreated(Document doc, EventLifeCycle state, Bundle extra) {
        if (state == EventLifeCycle.SERVER) {
            this.notifyDocumentEvent(doc, "NuxeoDocumentCreatedServer", extra);
        } else if (state == EventLifeCycle.CLIENT) {
            this.notifyDocumentEvent(doc, "NuxeoDocumentCreatedClient", extra);
        } else {
            this.notifyDocumentEvent(doc, "NuxeoDocumentCreatedFailer", extra);
        }
    }

    @Override
    public void notifyDocumentUpdated(Document doc, EventLifeCycle state, Bundle extra) {
        if (state == EventLifeCycle.SERVER) {
            this.notifyDocumentEvent(doc, "NuxeoDocumentUpdatedServer", extra);
        } else if (state == EventLifeCycle.CLIENT) {
            this.notifyDocumentEvent(doc, "NuxeoDocumentUpdatedClient", extra);
        } else {
            this.notifyDocumentEvent(doc, "NuxeoDocumentUpdatedFailed", extra);
        }
    }

    @Override
    public void notifyDocumentDeleted(Document doc, EventLifeCycle state, Bundle extra) {
        if (state == EventLifeCycle.SERVER) {
            this.notifyDocumentEvent(doc, "NuxeoDocumentDeletedServer", extra);
        } else if (state == EventLifeCycle.CLIENT) {
            this.notifyDocumentEvent(doc, "NuxeoDocumentDeletedClient", extra);
        } else {
            this.notifyDocumentEvent(doc, "NuxeoDocumentDeletedFailed", extra);
        }
    }

    @Override
    public void notifyDocumentEvent(Document doc, String event, Bundle extra) {
        Intent intent = new Intent();
        intent.setAction(event);
        if (doc != null) {
            intent.putExtra("NuxeoDocument", (Serializable)doc);
            Log.i((String)this.getClass().getSimpleName(), (String)("Sending message " + event + " on document " + doc.getId()));
        } else {
            Log.i((String)this.getClass().getSimpleName(), (String)("Sending message " + event));
        }
        if (extra != null) {
            intent.putExtras(extra);
        }
        this.ctx.sendBroadcast(intent);
    }
}

