/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.android;

import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.nuxeo.android.cache.blob.BlobStore;
import org.nuxeo.android.cache.blob.BlobStoreManager;
import org.nuxeo.android.cache.blob.BlobWithProperties;
import org.nuxeo.android.cache.sql.ResponseCacheTableWrapper;
import org.nuxeo.android.cache.sql.SQLStateManager;
import org.nuxeo.ecm.automation.client.cache.ResponseCacheEntry;
import org.nuxeo.ecm.automation.client.cache.ResponseCacheManager;
import org.nuxeo.ecm.automation.client.jaxrs.model.Blob;

public class AndroidResponseCacheManager
implements ResponseCacheManager {
    protected final SQLStateManager sqlStateManager;
    protected final BlobStore blobStore;
    protected final String BLOBSTORE_KEY = "responses";

    public AndroidResponseCacheManager(SQLStateManager sqlStateManager, BlobStoreManager blobStoreManager) {
        this.sqlStateManager = sqlStateManager;
        this.blobStore = blobStoreManager.getBlobStore("responses");
        sqlStateManager.registerWrapper(new ResponseCacheTableWrapper());
    }

    protected ResponseCacheTableWrapper getTableWrapper() {
        return (ResponseCacheTableWrapper)this.sqlStateManager.getTableWrapper("NuxeoCacheEntries");
    }

    @Override
    public InputStream storeResponse(String key, ResponseCacheEntry entry) {
        this.getTableWrapper().storeCacheEntry(key, entry);
        File cachedStream = this.storeStream(key, entry.getResponseStream());
        if (cachedStream == null) {
            Log.e((String)AndroidResponseCacheManager.class.getSimpleName(), (String)"Response stream is null !!!!!");
            return null;
        }
        try {
            return new FileInputStream(cachedStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected File storeStream(String key, InputStream is) {
        return this.blobStore.storeBlob(key, is, null, null);
    }

    protected InputStream getStream(String key) {
        BlobWithProperties blob = this.blobStore.getBlob(key);
        if (blob == null) {
            return null;
        }
        try {
            return ((Blob)blob).getStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ResponseCacheEntry getResponseFromCache(String key) {
        ResponseCacheEntry entry = this.getTableWrapper().getEntry(key);
        if (entry != null) {
            InputStream is = this.getStream(key);
            if (is == null) {
                return null;
            }
            entry.setResponseStream(is);
            return entry;
        }
        return entry;
    }

    @Override
    public long getEntryCount() {
        return this.getTableWrapper().getCount();
    }

    @Override
    public void clear() {
        this.blobStore.clear();
        this.getTableWrapper().clearTable();
    }

    @Override
    public long getSize() {
        return this.blobStore.getSize();
    }
}

