/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.android;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import java.util.List;
import org.nuxeo.android.cache.sql.SQLStateManager;
import org.nuxeo.android.cache.sql.TransientStateTableWrapper;
import org.nuxeo.ecm.automation.client.cache.DocumentDeltaSet;
import org.nuxeo.ecm.automation.client.cache.OperationType;
import org.nuxeo.ecm.automation.client.cache.TransientStateManager;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;
import org.nuxeo.ecm.automation.client.jaxrs.model.Documents;

public class AndroidTransientStateManager
extends BroadcastReceiver
implements TransientStateManager {
    protected final SQLStateManager stateManager;

    public AndroidTransientStateManager(Context androidContext, SQLStateManager stateManager) {
        IntentFilter filter = new IntentFilter();
        filter.addAction("NuxeoDocumentCreatedClient");
        filter.addAction("NuxeoDocumentCreatedServer");
        filter.addAction("NuxeoDocumentUpdatedClient");
        filter.addAction("NuxeoDocumentUpdatedServer");
        filter.addAction("NuxeoDocumentDeletedClient");
        filter.addAction("NuxeoDocumentDeletedServer");
        androidContext.registerReceiver((BroadcastReceiver)this, filter);
        stateManager.registerWrapper(new TransientStateTableWrapper());
        this.stateManager = stateManager;
    }

    protected TransientStateTableWrapper getTableWrapper() {
        return (TransientStateTableWrapper)this.stateManager.getTableWrapper("NuxeoTransientState");
    }

    public void storeDocumentState(Document doc, OperationType opType, String requestId, String listName) {
        DocumentDeltaSet delta = new DocumentDeltaSet(opType, doc, requestId, listName);
        this.getTableWrapper().storeDeltaSet(delta);
    }

    @Override
    public void storeDocumentState(Document doc, OperationType opType) {
        this.storeDocumentState(doc, opType, null, null);
    }

    @Override
    public List<DocumentDeltaSet> getDeltaSets(List<String> ids, String targetListName) {
        List<DocumentDeltaSet> deltas = this.getTableWrapper().getDeltaSets(ids, targetListName);
        return deltas;
    }

    @Override
    public Documents mergeTransientState(Documents docs, boolean add, String listName) {
        List<DocumentDeltaSet> deltas = this.getDeltaSets(docs.getIds(), listName);
        for (DocumentDeltaSet delta : deltas) {
            if (add && delta.getOperationType() == OperationType.CREATE && !docs.containsDocWithId(delta.getId())) {
                if (listName != null && !listName.equals(delta.getListName())) continue;
                docs.add(0, delta.apply(null));
                continue;
            }
            if (delta.getOperationType() == OperationType.UPDATE) {
                Document doc2Update = docs.getById(delta.getId());
                delta.apply(doc2Update);
                doc2Update.setInConflict(delta.isConflict());
                continue;
            }
            if (delta.getOperationType() != OperationType.DELETE) continue;
            docs.removeById(delta.getId());
        }
        return docs;
    }

    @Override
    public void flushTransientState(String uid) {
        this.getTableWrapper().deleteEntry(uid);
    }

    @Override
    public void flushTransientState() {
        this.getTableWrapper().clearTable();
    }

    public void onReceive(Context androidContext, Intent intent) {
        String eventName = intent.getAction();
        Document doc = (Document)intent.getExtras().get("NuxeoDocument");
        String requestId = intent.getExtras().getString("RequestId");
        String listName = intent.getExtras().getString("SourceDocumentsList");
        if (eventName.equals("NuxeoDocumentCreatedClient")) {
            this.storeDocumentState(doc, OperationType.CREATE, requestId, listName);
        } else if (eventName.equals("NuxeoDocumentUpdatedClient")) {
            this.storeDocumentState(doc, OperationType.UPDATE, requestId, listName);
        } else if (eventName.equals("NuxeoDocumentDeletedClient")) {
            this.storeDocumentState(doc, OperationType.DELETE, requestId, listName);
        } else if (eventName.equals("NuxeoDocumentUpdatedServer") || eventName.equals("NuxeoDocumentDeletedServer")) {
            if (doc != null) {
                this.flushTransientState(doc.getId());
            }
        } else if (eventName.equals("NuxeoDocumentCreatedServer") && requestId != null) {
            this.getTableWrapper().deleteEntryByRequestId(requestId);
        }
    }

    @Override
    public void markAsConflict(String uid) {
        this.getTableWrapper().updateConflictMarker(uid, true);
    }

    @Override
    public void markAsResolved(String uid) {
        this.getTableWrapper().updateConflictMarker(uid, false);
    }

    @Override
    public long getEntryCount() {
        return this.getTableWrapper().getCount();
    }
}

