/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.android;

import android.util.Log;
import java.io.File;
import java.io.IOException;
import org.nuxeo.android.cache.blob.BlobStoreManager;
import org.nuxeo.ecm.automation.client.android.AndroidAutomationClient;
import org.nuxeo.ecm.automation.client.android.CachedSession;
import org.nuxeo.ecm.automation.client.cache.ResponseCacheEntry;
import org.nuxeo.ecm.automation.client.jaxrs.LoginInfo;
import org.nuxeo.ecm.automation.client.jaxrs.impl.CacheKeyHelper;
import org.nuxeo.ecm.automation.client.jaxrs.spi.AbstractAutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshalling;
import org.nuxeo.ecm.automation.client.jaxrs.spi.OperationRegistry;
import org.nuxeo.ecm.automation.client.jaxrs.util.IOUtils;

public class SessionCache {
    protected String getCacheKey(String url, String username, String cacheKey) {
        String key = url + ":" + username + ":" + cacheKey;
        String sessionHash = CacheKeyHelper.getHash(key);
        return "session-" + sessionHash;
    }

    public CachedSession getCachedSession(AndroidAutomationClient client, String url, String username, String cacheKey) {
        String fileName;
        File rootDir = BlobStoreManager.getRootCacheDir(client.androidContext);
        File cache = new File(rootDir, fileName = this.getCacheKey(url, username, cacheKey));
        if (cache.exists()) {
            String automationDefKey = CacheKeyHelper.getOperationDefinitionsCacheKey(url);
            ResponseCacheEntry response = client.responseCacheManager.getResponseFromCache(automationDefKey);
            if (response == null) {
                return null;
            }
            try {
                OperationRegistry cachedregistry = JsonMarshalling.readRegistry(IOUtils.read(response.getResponseStream()));
                return new CachedSession((AbstractAutomationClient)client, cachedregistry, new LoginInfo(username));
            }
            catch (Exception e) {
                Log.e((String)this.getClass().getSimpleName(), (String)"Unable to create cached session", (Throwable)e);
            }
        }
        return null;
    }

    public void storeSession(AndroidAutomationClient client, String url, String username, String cacheKey) {
        File rootDir = BlobStoreManager.getRootCacheDir(client.androidContext);
        String fileName = this.getCacheKey(url, username, cacheKey);
        File cache = new File(rootDir, fileName);
        try {
            cache.createNewFile();
        }
        catch (IOException e) {
            Log.e((String)this.getClass().getSimpleName(), (String)"Unable to create Session cache file", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

