/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.android;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.io.Serializable;
import org.nuxeo.ecm.automation.client.jaxrs.AsyncCallbackWithProgress;

public abstract class UIAsyncCallback<T extends Serializable>
extends Handler
implements AsyncCallbackWithProgress<T> {
    protected static final int START = 1;
    protected static final int PROGRESS = 2;
    protected static final String PROGRESS_KEY = "progress";
    protected static final String EXECID_KEY = "executionId";
    protected static final String ERROR_KEY = "error";
    protected static final String DATA_KEY = "data";
    protected static final int END = 3;
    protected static final int CANCEL = 4;
    protected static final int ERROR = 5;

    @Override
    public void notifyProgressChange(int progress) {
        Log.i((String)UIAsyncCallback.class.getSimpleName(), (String)("Update : " + progress + "%"));
        Message msg = new Message();
        msg.what = 2;
        Bundle bundle = new Bundle();
        bundle.putInt(PROGRESS_KEY, progress);
        msg.setData(bundle);
        this.sendMessage(msg);
    }

    public void handleMessage(Message msg) {
        if (msg.what == 2) {
            this.onProgressUpdate(msg.getData().getInt(PROGRESS_KEY));
        } else if (msg.what == 1) {
            this.onStart();
        } else if (msg.what == 5) {
            this.onErrorUI(msg.getData().getString(EXECID_KEY), (Throwable)msg.getData().getSerializable(ERROR_KEY));
        } else if (msg.what == 3) {
            this.onSuccessUI(msg.getData().getString(EXECID_KEY), msg.getData().getSerializable(DATA_KEY));
        }
    }

    @Override
    public void notifyStart() {
        Message msg = new Message();
        msg.what = 1;
        this.sendMessage(msg);
    }

    public void notifyError(String message) {
        Message msg = new Message();
        msg.what = 5;
        Bundle bundle = new Bundle();
        bundle.putString(ERROR_KEY, message);
        msg.setData(bundle);
        this.sendMessage(msg);
    }

    @Override
    public void onError(String executionId, Throwable e) {
        Message msg = new Message();
        msg.what = 5;
        Bundle bundle = new Bundle();
        bundle.putString(EXECID_KEY, executionId);
        bundle.putSerializable(ERROR_KEY, (Serializable)e);
        Log.e((String)this.getClass().getSimpleName(), (String)"Error catched by handler", (Throwable)e);
        msg.setData(bundle);
        this.sendMessage(msg);
    }

    @Override
    public void onSuccess(String executionId, T data) {
        Message msg = new Message();
        msg.what = 3;
        Bundle bundle = new Bundle();
        bundle.putString(EXECID_KEY, executionId);
        bundle.putSerializable(DATA_KEY, data);
        msg.setData(bundle);
        this.sendMessage(msg);
    }
}

