/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.cache;

import java.io.InputStream;
import org.apache.http.client.HttpClient;
import org.nuxeo.android.network.NuxeoNetworkStatus;
import org.nuxeo.ecm.automation.client.cache.ResponseCacheEntry;
import org.nuxeo.ecm.automation.client.cache.ResponseCacheManager;
import org.nuxeo.ecm.automation.client.jaxrs.ConflictException;
import org.nuxeo.ecm.automation.client.jaxrs.RemoteException;
import org.nuxeo.ecm.automation.client.jaxrs.impl.CacheKeyHelper;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpConnector;
import org.nuxeo.ecm.automation.client.jaxrs.impl.NotAvailableOffline;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Connector;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Request;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Response;

public class CachedHttpConnector
extends HttpConnector
implements Connector {
    protected final ResponseCacheManager cacheManager;
    protected final NuxeoNetworkStatus offlineSettings;

    public CachedHttpConnector(HttpClient http, ResponseCacheManager cacheManager, NuxeoNetworkStatus offlineSettings) {
        super(http);
        this.cacheManager = cacheManager;
        this.offlineSettings = offlineSettings;
    }

    protected Object getResultFromCacheEntry(Request request, ResponseCacheEntry cachedResult) {
        System.out.println("Cache HIT");
        try {
            return request.handleResult(200, cachedResult.getReponseContentType(), cachedResult.getResponseContentDisposition(), cachedResult.getResponseStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Object execute(Request request, boolean forceRefresh, boolean cachable) {
        Object result;
        String cacheKey = null;
        ResponseCacheEntry cachedEntry = null;
        if (this.cacheManager != null && (cachedEntry = this.cacheManager.getResponseFromCache(cacheKey = CacheKeyHelper.computeRequestKey(request))) != null && !forceRefresh && (result = this.getResultFromCacheEntry(request, cachedEntry)) != null) {
            return result;
        }
        if (!this.offlineSettings.canUseNetwork()) {
            throw new NotAvailableOffline("No data in cache, must be online");
        }
        try {
            Response response = this.doExecute(request);
            if (response != null) {
                response = this.onBeforeResponseComplete(request, response, cacheKey);
                return response.getResult(request);
            }
            throw new RuntimeException("Cannot execute " + request);
        }
        catch (ConflictException e) {
            throw e;
        }
        catch (RemoteException e) {
            if (cachedEntry != null) {
                try {
                    return this.getResultFromCacheEntry(request, cachedEntry);
                }
                catch (Exception e2) {
                    throw e;
                }
            }
            throw e;
        }
        catch (Throwable t) {
            if (this.isNetworkError(t)) {
                this.offlineSettings.setNetworkReachable(false);
                if (cachedEntry != null) {
                    try {
                        return this.getResultFromCacheEntry(request, cachedEntry);
                    }
                    catch (Throwable t2) {
                        throw new NotAvailableOffline("Can not fetch result from cache", t2);
                    }
                }
                throw new NotAvailableOffline("No data in cache, must be online");
            }
            throw new RuntimeException("Cannot execute " + request, t);
        }
    }

    @Override
    protected boolean isNetworkError(Throwable t) {
        String className = t.getClass().getName();
        if (className.startsWith("java.net.")) {
            return true;
        }
        return className.startsWith("org.apache.http.conn.");
    }

    protected Response onBeforeResponseComplete(Request request, Response response, String cacheKey) {
        if (cacheKey != null && this.cacheManager != null && response.getStatus() == 200) {
            InputStream is = this.cacheManager.storeResponse(cacheKey, new ResponseCacheEntry(request, response));
            response.setInputStream(is);
        }
        return response;
    }
}

