/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.automation.client.cache.OperationType;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyList;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyMap;

public class DocumentDeltaSet {
    protected final OperationType opType;
    protected final PropertyMap dirtyProps;
    protected final String docType;
    protected final String path;
    protected final String id;
    protected final String requestId;
    protected final String listName;
    protected final List<String> pendingUploads;
    protected boolean conflict;
    protected static final String PENDING_UPLOAD_VPROB = "pending:upload";

    public DocumentDeltaSet(OperationType opType, String id, String path, String docType, PropertyMap dirtyProps, String requestId, String listName) {
        this.dirtyProps = dirtyProps;
        this.docType = docType;
        this.path = path;
        this.opType = opType;
        this.id = id;
        this.listName = listName;
        this.requestId = requestId;
        this.pendingUploads = new ArrayList<String>();
        if (dirtyProps.getList(PENDING_UPLOAD_VPROB, null) != null) {
            for (Serializable pid : dirtyProps.getList(PENDING_UPLOAD_VPROB).list()) {
                this.pendingUploads.add((String)((Object)pid));
            }
            dirtyProps.map().remove(PENDING_UPLOAD_VPROB);
        }
    }

    public DocumentDeltaSet(OperationType opType, Document doc, String requestId, String listName) {
        this.dirtyProps = doc.getDirtyProperties();
        this.docType = doc.getType();
        this.path = doc.getPath();
        this.opType = opType;
        this.id = doc.getId();
        this.listName = listName;
        this.requestId = requestId;
        List<String> uploadids = doc.getPendingUploads();
        if (uploadids != null && uploadids.size() > 0) {
            this.dirtyProps.set(PENDING_UPLOAD_VPROB, new PropertyList(new ArrayList<String>(uploadids)));
        }
        this.pendingUploads = uploadids;
    }

    public Document apply(Document doc) {
        if (this.opType == OperationType.CREATE) {
            return new Document(this.id, this.path, this.docType, this.dirtyProps);
        }
        if (this.opType == OperationType.UPDATE && doc != null) {
            doc.getProperties().map().putAll(this.dirtyProps.map());
            doc.getDirtyFields().addAll(this.dirtyProps.map().keySet());
        }
        return doc;
    }

    public OperationType getOperationType() {
        return this.opType;
    }

    public PropertyMap getDirtyProps() {
        return this.dirtyProps;
    }

    public String getDocType() {
        return this.docType;
    }

    public String getPath() {
        return this.path;
    }

    public String getId() {
        return this.id;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getListName() {
        return this.listName;
    }

    public boolean isConflict() {
        return this.conflict;
    }

    public void setConflict(boolean conflict) {
        this.conflict = conflict;
    }
}

