/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.automation.client.jaxrs.Dependency;

public class ExecutionDependencies
implements Iterable<Dependency> {
    protected final List<Dependency> dependencies = new ArrayList<Dependency>();

    public void add(Dependency.DependencyType type, String token) {
        this.dependencies.add(new Dependency(type, token));
    }

    @Override
    public Iterator<Dependency> iterator() {
        return this.dependencies.iterator();
    }

    public void markAsResolved(String key) {
        Iterator<Dependency> it = this.dependencies.iterator();
        while (it.hasNext()) {
            Dependency dep = it.next();
            if (!dep.token.equals(key)) continue;
            it.remove();
        }
    }

    public boolean resolved() {
        return this.dependencies.size() == 0;
    }

    public String asJSON() {
        JSONArray array = new JSONArray();
        for (Dependency dep : this.dependencies) {
            JSONObject ob = new JSONObject();
            try {
                ob.put(dep.getType().toString(), (Object)dep.getToken());
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            array.put((Object)ob);
        }
        return array.toString();
    }

    public static ExecutionDependencies fromJSON(String json) {
        ExecutionDependencies deps = new ExecutionDependencies();
        try {
            JSONArray array = new JSONArray(json);
            for (int i = 0; i < array.length(); ++i) {
                JSONObject ob = array.getJSONObject(i);
                Dependency.DependencyType type = Dependency.DependencyType.fromString((String)ob.keys().next());
                deps.add(type, ob.getString(type.toString()));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return deps;
    }

    public int size() {
        return this.dependencies.size();
    }

    public void merge(ExecutionDependencies deps) {
        if (deps != null) {
            for (Dependency dep : deps) {
                this.dependencies.add(dep);
            }
        }
    }
}

