/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshalling;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Request;

public class CacheKeyHelper {
    private CacheKeyHelper() {
    }

    public static String getHash(String valueToHash) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        digest.update(valueToHash.getBytes());
        byte[] messageDigest = digest.digest();
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < messageDigest.length; ++i) {
            hexString.append(Integer.toHexString(0xFF & messageDigest[i]));
        }
        return hexString.toString();
    }

    public static String getOperationDefinitionsCacheKey(String url) {
        String key = CacheKeyHelper.getHash(url) + "-automationDefinitions";
        return key;
    }

    public static String computeRequestKey(Request request) {
        String url = request.getUrl();
        if (url.endsWith("/login")) {
            return null;
        }
        if (url.endsWith("/automation/")) {
            return CacheKeyHelper.getOperationDefinitionsCacheKey(url);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(request.getUrl());
        sb.append(request.asStringEntity());
        return CacheKeyHelper.getHash(sb.toString());
    }

    public static String computeRequestKey(OperationRequest request) {
        String url = request.getUrl();
        if (url.endsWith("/login")) {
            return null;
        }
        if (url.endsWith("/automation/")) {
            return CacheKeyHelper.getOperationDefinitionsCacheKey(url);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(request.getUrl());
        try {
            sb.append(JsonMarshalling.writeRequest(request));
        }
        catch (Exception e1) {
            throw new RuntimeException("Unable to compute RequestKey", e1);
        }
        return CacheKeyHelper.getHash(sb.toString());
    }
}

