/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.impl;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.nuxeo.ecm.automation.client.jaxrs.RemoteException;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Connector;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Request;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Response;

public class HttpConnector
implements Connector {
    protected final HttpClient http;
    protected final HttpContext ctx;
    protected String basicAuth;

    public HttpConnector(HttpClient http) {
        this(http, (HttpContext)new BasicHttpContext());
    }

    public HttpConnector(HttpClient http, HttpContext ctx) {
        ctx.setAttribute("http.cookie-store", (Object)new BasicCookieStore());
        this.http = http;
        this.ctx = ctx;
    }

    @Override
    public Object execute(Request request) {
        return this.execute(request, false, true);
    }

    @Override
    public Object execute(Request request, boolean forceRefresh, boolean cachable) {
        try {
            Response response = this.doExecute(request);
            if (response != null) {
                return response.getResult(request);
            }
            throw new RuntimeException("Cannot execute " + request);
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot execute " + request, t);
        }
    }

    protected boolean isNetworkError(Throwable t) {
        String className = t.getClass().getName();
        if (className.startsWith("java.net.")) {
            return true;
        }
        return className.startsWith("org.apache.http.conn.");
    }

    protected Response doExecute(Request request) throws Exception {
        HttpGet httpReq = null;
        if (request.getMethod() == 1) {
            HttpPost post = new HttpPost(request.getUrl());
            Object obj = request.getEntity();
            if (obj != null) {
                StringEntity entity = null;
                if (request.isMultiPart()) {
                    throw new RuntimeException("MultiPart is not supported");
                }
                try {
                    entity = new StringEntity(obj.toString(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error("Cannot encode into UTF-8", e);
                }
                post.setEntity((HttpEntity)entity);
            }
            httpReq = post;
        } else {
            httpReq = new HttpGet(request.getUrl());
        }
        for (Map.Entry entry : request.entrySet()) {
            httpReq.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        HttpResponse resp = this.http.execute((HttpUriRequest)httpReq, this.ctx);
        HttpEntity entity = resp.getEntity();
        int status = resp.getStatusLine().getStatusCode();
        Request debug = request;
        if (status == 401) {
            String debugS = debug.toString();
        }
        if (entity == null) {
            if (status < 400) {
                return null;
            }
            throw new RemoteException(status, "ServerError", "Server Error", null);
        }
        Header ctypeHeader = entity.getContentType();
        if (ctypeHeader == null) {
            if (status != 200) {
                throw new RemoteException(status, "ServerError", "Server Error", null);
            }
            return null;
        }
        String ctype = ctypeHeader.getValue().toLowerCase();
        String disp = null;
        Header[] hdisp = resp.getHeaders("Content-Disposition");
        if (hdisp != null && hdisp.length > 0) {
            disp = hdisp[0].getValue();
        }
        InputStream is = entity.getContent();
        Response response = new Response(status, ctype, disp, is);
        return response;
    }

    @Override
    public HttpResponse executeSimpleHttp(HttpUriRequest httpRequest) throws Exception {
        return this.http.execute(httpRequest, this.ctx);
    }
}

