/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.impl;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.protocol.HttpContext;

public class HttpPreemptiveAuthInterceptor
implements HttpRequestInterceptor {
    protected final AuthScheme authScheme;

    HttpPreemptiveAuthInterceptor(AuthScheme authScheme) {
        this.authScheme = authScheme;
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpHost targetHost;
        AuthScope authScope;
        AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
        if (authState.getAuthScheme() != null) {
            return;
        }
        CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
        Credentials creds = credsProvider.getCredentials(authScope = new AuthScope((targetHost = (HttpHost)context.getAttribute("http.target_host")).getHostName(), targetHost.getPort()));
        if (creds == null) {
            System.out.println("no credentials provided for " + authScope);
            return;
        }
        authState.setAuthScheme(this.authScheme);
        authState.setCredentials(creds);
    }
}

