/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.model;

import android.net.Uri;
import android.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.nuxeo.android.contentprovider.NuxeoContentProviderConfig;
import org.nuxeo.ecm.automation.client.jaxrs.model.DocRef;
import org.nuxeo.ecm.automation.client.jaxrs.model.DocumentStatus;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertiesHelper;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyList;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyMap;

public class Document
extends DocRef
implements Serializable {
    private static final String NEW_UUID_PREFIX = "NEW-";
    private static final long serialVersionUID = 1L;
    protected final String parentPath;
    protected final String type;
    protected final String state;
    protected final String lock;
    protected final String repoName;
    protected final PropertyMap properties;
    protected final List<String> dirtyFields = new ArrayList<String>();
    protected String name;
    protected String changeToken;
    protected PropertyList facets;
    protected boolean inConflict = false;

    public Document(String repoName, String id, String type, PropertyList facets, String changeToken, String path, String state, String lock, PropertyMap properties) {
        super(id);
        int idx;
        this.type = type;
        this.state = state;
        this.lock = lock;
        this.properties = properties == null ? new PropertyMap() : properties;
        this.repoName = repoName;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        this.parentPath = (idx = path.lastIndexOf("/")) > 0 ? path.substring(0, idx) : null;
        this.name = path.substring(idx + 1);
        this.changeToken = changeToken;
        this.facets = facets;
    }

    public Document(String parentPath, String name, String type) {
        super(NEW_UUID_PREFIX + System.currentTimeMillis());
        this.parentPath = parentPath;
        this.state = null;
        this.type = type;
        this.lock = null;
        this.properties = new PropertyMap();
        this.repoName = null;
        this.name = name;
    }

    public Document(String id, String path, String type, PropertyMap dirtyProps) {
        super(id);
        this.type = type;
        int idx = path.lastIndexOf("/");
        this.parentPath = path.substring(0, idx);
        this.name = path.substring(idx + 1);
        this.state = null;
        this.properties = dirtyProps;
        this.repoName = null;
        this.lock = null;
        this.dirtyFields.addAll(dirtyProps.map.keySet());
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.ref;
    }

    @Override
    public String getInputType() {
        return "document";
    }

    public String getPath() {
        if (this.parentPath == null) {
            return "/";
        }
        if (!this.parentPath.endsWith("/")) {
            return this.parentPath + "/" + this.name;
        }
        return this.parentPath + this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getLock() {
        return this.lock;
    }

    public String getState() {
        return this.state;
    }

    public Date getLastModified() {
        return this.properties.getDate("dc:modified");
    }

    public String getTitle() {
        return this.properties.getString("dc:title");
    }

    public PropertyMap getProperties() {
        return this.properties;
    }

    public String getString(String key) {
        return this.properties.getString(key);
    }

    public Date getDate(String key) {
        return this.properties.getDate(key);
    }

    public Long getLong(String key) {
        return this.properties.getLong(key);
    }

    public Double getDouble(String key) {
        return this.properties.getDouble(key);
    }

    public String getString(String key, String defValue) {
        return this.properties.getString(key, defValue);
    }

    public Date getDate(String key, Date defValue) {
        return this.properties.getDate(key, defValue);
    }

    public Long getLong(String key, Long defValue) {
        return this.properties.getLong(key, defValue);
    }

    public Double getDouble(String key, Double defValue) {
        return this.properties.getDouble(key, defValue);
    }

    public void set(String key, String value) {
        this.properties.set(key, value);
        this.dirtyFields.add(key);
    }

    public void set(String key, Date value) {
        this.properties.set(key, value);
        this.dirtyFields.add(key);
    }

    public void set(String key, Long value) {
        this.properties.set(key, value);
        this.dirtyFields.add(key);
    }

    public void set(String key, Double value) {
        this.properties.set(key, value);
        this.dirtyFields.add(key);
    }

    public void set(String key, PropertyMap value) {
        this.properties.set(key, value);
        this.dirtyFields.add(key);
    }

    public void set(String key, PropertyList value) {
        this.properties.set(key, value);
        this.dirtyFields.add(key);
    }

    public String getRelativeUrl() {
        return "/nxpath/" + this.repoName + this.getPath() + "@view_documents";
    }

    public boolean isDirty() {
        return this.dirtyFields.size() > 0;
    }

    public PropertyMap getDirtyProperties() {
        PropertyMap dirtyProps = new PropertyMap();
        for (String key : this.dirtyFields) {
            dirtyProps.map().put(key, this.properties.map().get(key));
        }
        return dirtyProps;
    }

    public String getDirtyPropertiesAsPropertiesString() {
        String dirtyString = PropertiesHelper.toStringProperties(this.getDirtyProperties());
        Log.i((String)this.getClass().getSimpleName(), (String)("Dirty props => " + dirtyString));
        return dirtyString;
    }

    public DocumentStatus getStatusFlag() {
        if (this.inConflict) {
            return DocumentStatus.CONFLICT;
        }
        if (this.ref == null || this.ref.startsWith(NEW_UUID_PREFIX)) {
            return DocumentStatus.NEW;
        }
        if (this.isDirty()) {
            return DocumentStatus.UPDATED;
        }
        return DocumentStatus.SYNCHRONIZED;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public List<String> getDirtyFields() {
        return this.dirtyFields;
    }

    public Uri getIcon() {
        String icon = this.getString("common:icon");
        if (icon == null || "null".equals(icon) || icon.equals("")) {
            return null;
        }
        return Uri.parse((String)("content://" + NuxeoContentProviderConfig.getAuthority() + "/icons" + this.getString("common:icon")));
    }

    public Uri getBlob() {
        return this.getBlob(0);
    }

    public Uri getBlob(int idx) {
        List<String> rids;
        if ((this.getStatusFlag().equals((Object)DocumentStatus.NEW) || this.getStatusFlag().equals((Object)DocumentStatus.UPDATED)) && (rids = this.getPendingUploads()).size() > 0) {
            String rid = rids.get(0);
            return Uri.parse((String)("content://" + NuxeoContentProviderConfig.getAuthority() + "/uploads/" + rid + "/"));
        }
        return Uri.parse((String)("content://" + NuxeoContentProviderConfig.getAuthority() + "/blobs/" + this.getId() + "/" + idx));
    }

    public Uri getPicture(String format) {
        List<String> rids;
        if ((this.getStatusFlag().equals((Object)DocumentStatus.NEW) || this.getStatusFlag().equals((Object)DocumentStatus.UPDATED)) && (rids = this.getPendingUploads()).size() > 0) {
            String rid = rids.get(0);
            return Uri.parse((String)("content://" + NuxeoContentProviderConfig.getAuthority() + "/uploads/" + rid));
        }
        if (format == null) {
            return Uri.parse((String)("content://" + NuxeoContentProviderConfig.getAuthority() + "/pictures/" + this.getId() + "/"));
        }
        String uri = "content://" + NuxeoContentProviderConfig.getAuthority() + "/pictures/" + this.getId() + "/" + format;
        return Uri.parse((String)uri);
    }

    public List<String> getPendingUploads() {
        ArrayList<String> tokens = new ArrayList<String>();
        for (String key : this.dirtyFields) {
            String token;
            PropertyMap map;
            Object prop = this.properties.get(key);
            if (prop == null || !(prop instanceof PropertyMap) || !(map = (PropertyMap)prop).getString("type", "").equals("blob") || (token = map.getString("android-require-uuid", null)) == null) continue;
            tokens.add(token);
        }
        return tokens;
    }

    public String getChangeToken() {
        return this.changeToken;
    }

    public PropertyList getFacets() {
        return this.facets;
    }

    public void setInConflict(boolean inConflict) {
        this.inConflict = inConflict;
    }

    public boolean isFolder() {
        return this.facets.list.contains("Folderish");
    }
}

