/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.model;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.android.adapters.NuxeoDocumentCursor;
import org.nuxeo.android.documentprovider.LazyDocumentsList;
import org.nuxeo.android.documentprovider.LazyDocumentsListImpl;
import org.nuxeo.android.documentprovider.LazyUpdatableDocumentsList;
import org.nuxeo.android.documentprovider.LazyUpdatableDocumentsListImpl;
import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;
import org.nuxeo.ecm.automation.client.jaxrs.model.OperationInput;

public class Documents
extends ArrayList<Document>
implements OperationInput {
    private static final long serialVersionUID = 1L;
    protected boolean batched = false;
    protected int pageSize = 0;
    protected int pageIndex = 0;
    protected int pageCount = 0;
    protected int totalSize = 0;
    protected OperationRequest sourceRequest;

    public Documents() {
    }

    public Documents(int size) {
        super(size);
    }

    public Documents(int size, int totalSize, int pageSize, int pageIndex, int pageCount) {
        super(size);
        this.batched = true;
        this.totalSize = totalSize;
        this.pageSize = pageSize;
        this.pageIndex = pageIndex;
        this.pageCount = pageCount;
    }

    public Documents(Documents docs, int totalSize, int pageSize, int pageIndex, int pageCount) {
        super(docs);
        this.batched = true;
        this.totalSize = totalSize;
        this.pageSize = pageSize;
        this.pageIndex = pageIndex;
        this.pageCount = pageCount;
    }

    public Documents(Documents docs) {
        super(docs);
    }

    @Override
    public String getInputType() {
        return "documents";
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public String getInputRef() {
        StringBuilder buf = new StringBuilder();
        int size = this.size();
        if (size == 0) {
            return buf.toString();
        }
        buf.append(((Document)this.get(0)).getId());
        for (int i = 1; i < size; ++i) {
            buf.append(",").append(((Document)this.get(i)).getId());
        }
        return buf.toString();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("docs:");
        int size = this.size();
        if (size == 0) {
            return buf.toString();
        }
        buf.append(((Document)this.get(0)).getId());
        for (int i = 1; i < size; ++i) {
            buf.append(",").append(((Document)this.get(i)).getId());
        }
        return buf.toString();
    }

    public String dump() {
        return super.toString();
    }

    public boolean isBatched() {
        return this.batched;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public int getPageCount() {
        if (this.batched) {
            return this.pageCount;
        }
        return 1;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public OperationRequest getSourceRequest() {
        return this.sourceRequest;
    }

    public void setSourceRequest(OperationRequest sourceRequest) {
        this.sourceRequest = sourceRequest;
    }

    public NuxeoDocumentCursor asCursor(String pageParameterName) {
        NuxeoDocumentCursor cursor = new NuxeoDocumentCursor(this.sourceRequest, pageParameterName, false);
        return cursor;
    }

    public NuxeoDocumentCursor asCursor() {
        return this.asCursor("page");
    }

    public NuxeoDocumentCursor asUpdatableCursor(String pageParameterName) {
        NuxeoDocumentCursor cursor = new NuxeoDocumentCursor(this.sourceRequest, pageParameterName, true);
        return cursor;
    }

    public LazyDocumentsList asDocumentsList() {
        return new LazyDocumentsListImpl(this.sourceRequest, "page");
    }

    public LazyUpdatableDocumentsList asUpdatableDocumentsList() {
        return new LazyUpdatableDocumentsListImpl(this.sourceRequest, "page");
    }

    public void removeById(String uid) {
        for (int i = 0; i < this.size(); ++i) {
            if (!uid.equals(((Document)this.get(i)).getId())) continue;
            this.remove(i);
            break;
        }
    }

    public boolean containsDocWithId(String uid) {
        for (int i = 0; i < this.size(); ++i) {
            if (!uid.equals(((Document)this.get(i)).getId())) continue;
            return true;
        }
        return false;
    }

    public Document getById(String uid) {
        for (int i = 0; i < this.size(); ++i) {
            if (!uid.equals(((Document)this.get(i)).getId())) continue;
            return (Document)this.get(i);
        }
        return null;
    }

    public List<String> getIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < this.size(); ++i) {
            ids.add(((Document)this.get(i)).getId());
        }
        return ids;
    }
}

