/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.model;

import android.util.Log;
import java.io.Serializable;
import java.util.Date;
import org.json.JSONObject;
import org.nuxeo.ecm.automation.client.jaxrs.model.Blob;
import org.nuxeo.ecm.automation.client.jaxrs.model.DateUtils;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyList;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyMap;

public class PropertiesHelper {
    public static boolean isBlob(Object v) {
        return v instanceof Blob;
    }

    public static boolean isMap(Object v) {
        return v instanceof PropertyMap;
    }

    public static boolean isList(Object v) {
        return v instanceof PropertyList;
    }

    public static boolean isScalar(Object v) {
        return !PropertiesHelper.isBlob(v) && !PropertiesHelper.isList(v) && !PropertiesHelper.isMap(v);
    }

    public static String getString(Object v, String defValue) {
        if (v == null) {
            return defValue;
        }
        if (v.getClass() == String.class) {
            return v.toString();
        }
        throw new IllegalArgumentException("Property is not a scalar: " + v);
    }

    public static Boolean getBoolean(Object v, Boolean defValue) {
        if (v == null) {
            return defValue;
        }
        if (v.getClass() == String.class) {
            return Boolean.valueOf(v.toString());
        }
        throw new IllegalArgumentException("Property is not a scalar: " + v);
    }

    public static Long getLong(Object v, Long defValue) {
        if (v == null) {
            return defValue;
        }
        if (v.getClass() == String.class) {
            return Long.valueOf(v.toString());
        }
        throw new IllegalArgumentException("Property is not a scalar: " + v);
    }

    public static Double getDouble(Object v, Double defValue) {
        if (v == null) {
            return defValue;
        }
        if (v.getClass() == String.class) {
            return Double.valueOf(v.toString());
        }
        throw new IllegalArgumentException("Property is not a scalar: " + v);
    }

    public static Date getDate(Object v, Date defValue) {
        if (v == null || "null".equals(v)) {
            return defValue;
        }
        if (v.getClass() == String.class) {
            String dateString = v.toString().substring(0, 10);
            return DateUtils.parseDate(dateString);
        }
        throw new IllegalArgumentException("Property is not a scalar: " + v);
    }

    public static PropertyList getList(Object v, PropertyList defValue) {
        if (v == null) {
            return defValue;
        }
        if (v instanceof PropertyList) {
            return (PropertyList)v;
        }
        throw new IllegalArgumentException("Property is not a list: " + v);
    }

    public static PropertyMap getMap(Object v, PropertyMap defValue) {
        if (v == null) {
            return defValue;
        }
        if (v instanceof PropertyMap) {
            return (PropertyMap)v;
        }
        throw new IllegalArgumentException("Property is not a map: " + v);
    }

    public static String toStringProperties(PropertyMap props) {
        StringBuffer sb = new StringBuffer();
        for (String propName : props.getKeys()) {
            Object value = props.map().get(propName);
            if (value != null) {
                sb.append(propName);
                sb.append("=");
                sb.append(PropertiesHelper.encodePropertyAsString(value));
                sb.append("\n");
                continue;
            }
            Log.w((String)PropertiesHelper.class.getSimpleName(), (String)("No value for " + propName));
        }
        return sb.toString();
    }

    public static String encodePropertyAsString(Object prop) {
        if (prop instanceof PropertyList) {
            PropertyList list = (PropertyList)prop;
            StringBuffer sb = new StringBuffer();
            for (Serializable item : list.list()) {
                sb.append(PropertiesHelper.encodePropertyAsString(item));
                sb.append(";");
            }
            return sb.toString();
        }
        if (prop instanceof PropertyMap) {
            PropertyMap map = (PropertyMap)prop;
            return new JSONObject(map.map()).toString();
        }
        String value = prop.toString();
        return value.replace("\n", " \\\n");
    }
}

