/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.nuxeo.ecm.automation.client.jaxrs.model.DateUtils;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertiesHelper;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyMap;

public class PropertyList
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final List<Serializable> list;

    public PropertyList() {
        this.list = new ArrayList<Serializable>();
    }

    public PropertyList(int size) {
        this.list = new ArrayList<Serializable>(size);
    }

    public PropertyList(List<Serializable> list) {
        this.list = new ArrayList<Serializable>(list);
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public String getString(int i) {
        return this.getString(i, null);
    }

    public Boolean getBoolean(int i) {
        return this.getBoolean(i, null);
    }

    public Long getLong(int i) {
        return this.getLong(i, null);
    }

    public Double getDouble(int i) {
        return this.getDouble(i, null);
    }

    public Date getDate(int i) {
        return this.getDate(i, null);
    }

    public PropertyList getList(int i) {
        return this.getList(i, null);
    }

    public PropertyMap getMap(int i) {
        return this.getMap(i, null);
    }

    public String getString(int i, String defValue) {
        return PropertiesHelper.getString(this.list.get(i), defValue);
    }

    public Boolean getBoolean(int i, Boolean defValue) {
        return PropertiesHelper.getBoolean(this.list.get(i), defValue);
    }

    public Long getLong(int i, Long defValue) {
        return PropertiesHelper.getLong(this.list.get(i), defValue);
    }

    public Double getDouble(int i, Double defValue) {
        return PropertiesHelper.getDouble(this.list.get(i), defValue);
    }

    public Date getDate(int i, Date defValue) {
        return PropertiesHelper.getDate(this.list.get(i), defValue);
    }

    public PropertyList getList(int i, PropertyList defValue) {
        return PropertiesHelper.getList(this.list.get(i), defValue);
    }

    public PropertyMap getMap(int i, PropertyMap defValue) {
        return PropertiesHelper.getMap(this.list.get(i), defValue);
    }

    public void set(int i, String value) {
        if (value == null) {
            this.list.remove(i);
        }
        this.list.set(i, (Serializable)((Object)value));
    }

    public void set(int i, Boolean value) {
        if (value == null) {
            this.list.remove(i);
        }
        this.list.set(i, (Serializable)((Object)value.toString()));
    }

    public void set(int i, Long value) {
        if (value == null) {
            this.list.remove(i);
        }
        this.list.set(i, (Serializable)((Object)value.toString()));
    }

    public void set(int i, Double value) {
        if (value == null) {
            this.list.remove(i);
        }
        this.list.set(i, (Serializable)((Object)value.toString()));
    }

    public void set(int i, Date value) {
        if (value == null) {
            this.list.remove(i);
        }
        this.list.set(i, (Serializable)((Object)DateUtils.formatDate(value)));
    }

    public void set(int i, PropertyList value) {
        if (value == null) {
            this.list.remove(i);
        }
        this.list.set(i, value);
    }

    public void set(int i, PropertyMap value) {
        if (value == null) {
            this.list.remove(i);
        }
        this.list.set(i, value);
    }

    public void add(String value) {
        this.list.add((Serializable)((Object)value));
    }

    public void add(Boolean value) {
        this.list.add((Serializable)((Object)value.toString()));
    }

    public void add(Long value) {
        this.list.add((Serializable)((Object)value.toString()));
    }

    public void add(Double value) {
        this.list.add((Serializable)((Object)value.toString()));
    }

    public void add(Date value) {
        this.list.add((Serializable)((Object)DateUtils.formatDate(value)));
    }

    public void add(PropertyList value) {
        this.list.add(value);
    }

    public void add(PropertyMap value) {
        this.list.add(value);
    }

    public List<Serializable> list() {
        return this.list;
    }

    public String toString() {
        return this.list.toString();
    }
}

