/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.client.broadcast.DocumentMessageService;
import org.nuxeo.ecm.automation.client.cache.OperationType;
import org.nuxeo.ecm.automation.client.jaxrs.AdapterFactory;
import org.nuxeo.ecm.automation.client.jaxrs.AsyncCallback;
import org.nuxeo.ecm.automation.client.jaxrs.AutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.LoginInfo;
import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.RequestInterceptor;
import org.nuxeo.ecm.automation.client.jaxrs.Session;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Connector;
import org.nuxeo.ecm.automation.client.jaxrs.spi.ConnectorHandler;
import org.nuxeo.ecm.automation.client.jaxrs.spi.DefaultSession;
import org.nuxeo.ecm.automation.client.jaxrs.spi.OperationRegistry;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Request;
import org.nuxeo.ecm.automation.client.jaxrs.spi.auth.BasicAuthInterceptor;

public abstract class AbstractAutomationClient
implements AutomationClient {
    private static final String TAG = "AbstractAutomationClient";
    protected String url;
    protected volatile OperationRegistry registry;
    protected Map<Class<?>, List<AdapterFactory<?>>> adapters = new HashMap();
    protected RequestInterceptor requestInterceptor;

    protected AbstractAutomationClient(String url) {
        this.url = url.endsWith("/") ? url : url + "/";
    }

    @Override
    public void setRequestInterceptor(RequestInterceptor interceptor) {
        this.requestInterceptor = interceptor;
    }

    @Override
    public RequestInterceptor getRequestInterceptor() {
        return this.requestInterceptor;
    }

    @Override
    public String getBaseUrl() {
        return this.url;
    }

    @Override
    public void setBasicAuth(String username, String password) {
        this.setRequestInterceptor(new BasicAuthInterceptor(username, password));
    }

    protected OperationRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void registerAdapter(AdapterFactory<?> factory) {
        Class<?> adapter = factory.getAdapterType();
        List<AdapterFactory<?>> factories = this.adapters.get(adapter);
        if (factories == null) {
            factories = new ArrayList();
            this.adapters.put(adapter, factories);
        }
        factories.add(factory);
    }

    @Override
    public <T> T getAdapter(Object objToAdapt, Class<T> adapterType) {
        Class<?> cls = objToAdapt.getClass();
        List<AdapterFactory<?>> factories = this.adapters.get(adapterType);
        if (factories != null) {
            for (AdapterFactory<?> f : factories) {
                if (!f.getAcceptType().isAssignableFrom(cls)) continue;
                return (T)f.getAdapter(objToAdapt);
            }
        }
        return null;
    }

    protected OperationRegistry connect(Connector connector) {
        Log.w((String)TAG, (String)"Using Synch request to init the automation session");
        Log.d((String)TAG, (String)this.url);
        Request req = new Request(0, this.url);
        req.put("Accept", "application/json+nxautomation");
        return (OperationRegistry)connector.execute(req);
    }

    @Override
    public synchronized void shutdown() {
        this.url = null;
        this.registry = null;
        this.adapters = null;
    }

    @Override
    public boolean isShutdown() {
        return this.url == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session getSession() {
        Connector connector = this.getConnector();
        if (this.registry == null) {
            AbstractAutomationClient abstractAutomationClient = this;
            synchronized (abstractAutomationClient) {
                if (this.registry == null) {
                    this.registry = this.connect(connector);
                }
            }
        }
        return this.login(connector);
    }

    public Connector getConnector() {
        Connector connector = this.newConnector();
        if (this.requestInterceptor != null) {
            connector = new ConnectorHandler(connector, this.requestInterceptor);
        }
        return connector;
    }

    @Override
    @Deprecated
    public Session getSession(String username, String password) {
        this.setBasicAuth(username, password);
        Session session = null;
        try {
            session = this.getSession();
        }
        catch (Throwable t) {
            Log.e((String)this.getClass().getSimpleName(), (String)"Unable to create live session", (Throwable)t);
        }
        return session;
    }

    @Override
    @Deprecated
    public void getSession(String username, String password, AsyncCallback<Session> cb) {
        this.setBasicAuth(username, password);
        this.getSession(cb);
    }

    @Override
    public void getSession(final AsyncCallback<Session> cb) {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Session session = AbstractAutomationClient.this.getSession();
                    cb.onSuccess(null, session);
                }
                catch (Throwable t) {
                    cb.onError(null, t);
                }
            }
        });
    }

    protected Session login(Connector connector) {
        Request request = new Request(1, this.url + this.getRegistry().getPath("login"));
        request.put("Accept", "application/json+nxentity");
        LoginInfo login = (LoginInfo)connector.execute(request);
        return this.createSession(connector, login);
    }

    protected Session createSession(Connector connector, LoginInfo login) {
        return new DefaultSession(this, connector, login == null ? LoginInfo.ANONYNMOUS : login);
    }

    public void asyncExec(Runnable runnable) {
        throw new UnsupportedOperationException("Async execution not supported");
    }

    public String asyncExec(Session session, OperationRequest request, AsyncCallback<Object> cb) {
        throw new UnsupportedOperationException("Async execution not supported");
    }

    protected abstract Connector newConnector();

    @Override
    public boolean isOffline() {
        return false;
    }

    public String execDeferredUpdate(OperationRequest request, AsyncCallback<Object> cb, OperationType opType) {
        throw new UnsupportedOperationException("No deferred update manager");
    }

    public DocumentMessageService getMessageHelper() {
        throw new UnsupportedOperationException("No MessageHelper");
    }
}

