/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import android.util.Log;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.nuxeo.ecm.automation.client.jaxrs.AsyncCallback;
import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.Session;
import org.nuxeo.ecm.automation.client.jaxrs.impl.CacheKeyHelper;
import org.nuxeo.ecm.automation.client.jaxrs.spi.AbstractAutomationClient;

public abstract class AsyncAutomationClient
extends AbstractAutomationClient {
    protected static final int NB_THREADS = 4;
    protected static final int QUEUESIZE = 20;
    protected ExecutorService async;
    protected CopyOnWriteArrayList<String> inprogressRequests = new CopyOnWriteArrayList();
    protected ConcurrentHashMap<String, CopyOnWriteArrayList<AsyncCallback<Object>>> pendingCallBacks = new ConcurrentHashMap();

    public AsyncAutomationClient(String url) {
        this(url, new ThreadPoolExecutor(0, 4, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(20)));
    }

    public AsyncAutomationClient(String url, ExecutorService executor) {
        super(url);
        this.async = executor;
        ((ThreadPoolExecutor)this.async).prestartAllCoreThreads();
    }

    protected void afterRequestSuccess(String requestKey, Object result) {
        if (this.pendingCallBacks.containsKey(requestKey)) {
            for (AsyncCallback<Object> cb : this.pendingCallBacks.get(requestKey)) {
                cb.onSuccess(requestKey, result);
            }
        }
    }

    protected void afterRequestFailure(String requestKey, Throwable t) {
        if (this.pendingCallBacks.containsKey(requestKey)) {
            for (AsyncCallback<Object> cb : this.pendingCallBacks.get(requestKey)) {
                cb.onError(requestKey, t);
            }
        }
    }

    @Override
    public String asyncExec(final Session session, final OperationRequest request, final AsyncCallback<Object> cb) {
        final String requestKey = CacheKeyHelper.computeRequestKey(request);
        if (this.inprogressRequests.addIfAbsent(requestKey)) {
            Log.i((String)AsyncAutomationClient.class.getSimpleName(), (String)"Adding task in the pool");
            Runnable task = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Log.i((String)AsyncAutomationClient.class.getSimpleName(), (String)"Starting task exec");
                    try {
                        Object result = session.execute(request);
                        cb.onSuccess(requestKey, result);
                        AsyncAutomationClient.this.afterRequestSuccess(requestKey, result);
                    }
                    catch (Throwable t) {
                        cb.onError(requestKey, t);
                        AsyncAutomationClient.this.afterRequestFailure(requestKey, t);
                    }
                    finally {
                        AsyncAutomationClient.this.inprogressRequests.remove(requestKey);
                    }
                }
            };
            this.async.execute(task);
            Log.i((String)AsyncAutomationClient.class.getSimpleName(), (String)"New task added to the pool");
        } else {
            Log.i((String)AsyncAutomationClient.class.getSimpleName(), (String)"Stacking duplicated request");
            CopyOnWriteArrayList<AsyncCallback<Object>> existingQueue = this.pendingCallBacks.get(requestKey);
            if (existingQueue == null) {
                existingQueue = new CopyOnWriteArrayList();
            }
            this.pendingCallBacks.putIfAbsent(requestKey, existingQueue);
            existingQueue.add(cb);
        }
        return requestKey;
    }

    @Override
    public void asyncExec(Runnable runnable) {
        this.async.execute(runnable);
    }

    @Override
    public synchronized void shutdown() {
        try {
            this.async.awaitTermination(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Log.e((String)this.getClass().getName(), (String)e.getMessage(), (Throwable)e);
        }
        super.shutdown();
        this.async = null;
    }

    @Override
    public boolean isShutdown() {
        return this.async == null || this.async.isShutdown() || super.isShutdown();
    }
}

