/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.client.jaxrs.AsyncCallback;
import org.nuxeo.ecm.automation.client.jaxrs.ExecutionDependencies;
import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.Session;
import org.nuxeo.ecm.automation.client.jaxrs.model.OperationDocumentation;
import org.nuxeo.ecm.automation.client.jaxrs.model.OperationInput;
import org.nuxeo.ecm.automation.client.jaxrs.spi.DefaultSession;
import org.nuxeo.ecm.automation.client.jaxrs.util.ParamsHelper;

public class DefaultOperationRequest
implements OperationRequest {
    protected final OperationDocumentation op;
    protected final DefaultSession session;
    protected final Map<String, String> params;
    protected final Map<String, String> ctx;
    protected final Map<String, String> headers;
    protected OperationInput input;
    protected boolean cachable = true;
    protected boolean refresh = false;
    protected ExecutionDependencies dependencies;

    public DefaultOperationRequest(DefaultSession session, OperationDocumentation op) {
        this(session, op, new HashMap<String, String>());
    }

    public DefaultOperationRequest(DefaultSession session, OperationDocumentation op, Map<String, String> ctx) {
        this.session = session;
        this.op = op;
        this.params = new HashMap<String, String>();
        this.headers = new HashMap<String, String>();
        this.ctx = ctx;
    }

    public DefaultOperationRequest(DefaultSession session, OperationDocumentation op, Map<String, String> params, Map<String, String> headers, Map<String, String> ctx, OperationInput input) {
        this.session = session;
        this.op = op;
        this.params = new HashMap<String, String>(params);
        this.headers = new HashMap<String, String>(headers);
        this.ctx = new HashMap<String, String>(ctx);
        this.input = input;
    }

    @Override
    public OperationRequest clone() {
        return this.clone(this.session);
    }

    @Override
    public OperationRequest clone(Session session) {
        DefaultOperationRequest clone = new DefaultOperationRequest((DefaultSession)session, this.op, this.params, this.headers, this.ctx, this.input);
        return clone;
    }

    @Override
    public DefaultSession getSession() {
        return this.session;
    }

    protected final boolean acceptInput(String type) {
        int size = this.op.signature.length;
        for (int i = 0; i < size; i += 2) {
            if ("void".equals(this.op.signature[i])) {
                return true;
            }
            if (!type.equals(this.op.signature[i])) continue;
            return true;
        }
        return false;
    }

    protected final void checkInput(String type) {
        if (!this.acceptInput(type)) {
            throw new IllegalArgumentException("Input not supported: " + type);
        }
    }

    public List<String> getParamNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (OperationDocumentation.Param param : this.op.params) {
            result.add(param.name);
        }
        return result;
    }

    @Override
    public OperationDocumentation.Param getParam(String key) {
        for (OperationDocumentation.Param param : this.op.params) {
            if (!key.equals(param.name)) continue;
            return param;
        }
        return null;
    }

    @Override
    public OperationRequest setInput(OperationInput input) {
        if (input == null) {
            this.checkInput("void");
        } else {
            this.checkInput(input.getInputType());
        }
        this.input = input;
        return this;
    }

    @Override
    public OperationInput getInput() {
        return this.input;
    }

    @Override
    public String getUrl() {
        return this.session.getClient().getBaseUrl() + this.op.url;
    }

    @Override
    public OperationRequest set(String key, Object value) {
        OperationDocumentation.Param param = this.getParam(key);
        if (param == null) {
            throw new IllegalArgumentException("No such parameter '" + key + "' for operation " + this.op.id + ".\n\tAvailable params: " + this.getParamNames());
        }
        if (value == null) {
            this.params.remove(key);
            return this;
        }
        String encodedValue = null;
        encodedValue = value.getClass() == Date.class ? ParamsHelper.encodeParam((Date)value) : (value instanceof String[] ? ParamsHelper.encodeParam((String[])value) : value.toString());
        this.params.put(key, encodedValue);
        return this;
    }

    @Override
    public OperationRequest setContextProperty(String key, String value) {
        this.ctx.put(key, value);
        return this;
    }

    @Override
    public Map<String, String> getContextParameters() {
        return this.ctx;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.params;
    }

    protected void setCacheFlags(byte cacheFlags) {
        this.refresh = (cacheFlags & 2) == 2;
        this.cachable = (cacheFlags & 1) == 1;
    }

    @Override
    public Object execute(byte cacheFlags) throws Exception {
        this.setCacheFlags(cacheFlags);
        return this.session.execute(this);
    }

    @Override
    public Object execute() throws Exception {
        return this.session.execute(this);
    }

    @Override
    public String execute(AsyncCallback<Object> cb) {
        return this.session.execute(this, cb);
    }

    @Override
    public String execute(AsyncCallback<Object> cb, byte cacheFlags) {
        this.setCacheFlags(cacheFlags);
        return this.session.execute(this, cb);
    }

    @Override
    public OperationRequest setHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public boolean isCachable() {
        return this.cachable;
    }

    @Override
    public boolean isForceRefresh() {
        return this.refresh;
    }

    @Override
    public void forceCache() {
        this.cachable = false;
        this.refresh = false;
    }

    @Override
    public OperationDocumentation getDocumentation() {
        return this.op;
    }

    @Override
    public ExecutionDependencies getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new ExecutionDependencies();
        }
        return this.dependencies;
    }

    @Override
    public boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.resolved();
    }
}

