/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.client.broadcast.DocumentMessageService;
import org.nuxeo.ecm.automation.client.cache.OperationType;
import org.nuxeo.ecm.automation.client.jaxrs.AsyncCallback;
import org.nuxeo.ecm.automation.client.jaxrs.AutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.LoginInfo;
import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.Session;
import org.nuxeo.ecm.automation.client.jaxrs.model.Blob;
import org.nuxeo.ecm.automation.client.jaxrs.model.Blobs;
import org.nuxeo.ecm.automation.client.jaxrs.model.Documents;
import org.nuxeo.ecm.automation.client.jaxrs.model.OperationDocumentation;
import org.nuxeo.ecm.automation.client.jaxrs.model.OperationInput;
import org.nuxeo.ecm.automation.client.jaxrs.spi.AbstractAutomationClient;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Connector;
import org.nuxeo.ecm.automation.client.jaxrs.spi.DefaultOperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.spi.JsonMarshalling;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Request;

public class DefaultSession
implements Session {
    protected final AbstractAutomationClient client;
    protected final Connector connector;
    protected final LoginInfo login;

    public DefaultSession(AbstractAutomationClient client, Connector connector, LoginInfo login) {
        this.client = client;
        this.connector = connector;
        this.login = login;
    }

    @Override
    public AutomationClient getClient() {
        return this.client;
    }

    public Connector getConnector() {
        return this.connector;
    }

    @Override
    public LoginInfo getLogin() {
        return this.login;
    }

    @Override
    public <T> T getAdapter(Class<T> type) {
        return this.client.getAdapter(this, type);
    }

    @Override
    public Object execute(OperationRequest request) throws Exception {
        String content = JsonMarshalling.writeRequest(request);
        OperationInput input = request.getInput();
        if (input != null && input.isBinary()) {
            throw new Exception("Binary request are not supported");
        }
        Request req = new Request(1, request.getUrl(), content);
        String ctype = "application/json+nxrequest";
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            req.put(entry.getKey(), entry.getValue());
        }
        req.put("Accept", "application/json+nxentity, */*");
        req.put("Content-Type", ctype);
        boolean refresh = request.isForceRefresh() && !this.client.isOffline();
        Object result = this.connector.execute(req, refresh, request.isCachable());
        if (result != null && result instanceof Documents) {
            ((Documents)result).setSourceRequest(request);
        }
        return result;
    }

    @Override
    public String execute(OperationRequest request, AsyncCallback<Object> cb) {
        return this.client.asyncExec(this, request, cb);
    }

    @Override
    public Blob getFile(String path) throws Exception {
        Request req = new Request(0, this.client.getBaseUrl() + path);
        return (Blob)this.connector.execute(req);
    }

    @Override
    public Blobs getFiles(String path) throws Exception {
        Request req = new Request(0, this.client.getBaseUrl() + path);
        return (Blobs)this.connector.execute(req);
    }

    @Override
    public String getFile(final String path, final AsyncCallback<Blob> cb) throws Exception {
        final String requestKey = "file:" + path;
        this.client.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    cb.onSuccess(requestKey, DefaultSession.this.getFile(path));
                }
                catch (Throwable t) {
                    cb.onError(requestKey, t);
                }
            }
        });
        return requestKey;
    }

    @Override
    public String getFiles(final String path, final AsyncCallback<Blobs> cb) throws Exception {
        final String requestKey = "files:" + path;
        this.client.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    cb.onSuccess(requestKey, DefaultSession.this.getFiles(path));
                }
                catch (Throwable t) {
                    cb.onError(requestKey, t);
                }
            }
        });
        return requestKey;
    }

    @Override
    public OperationRequest newRequest(String id) {
        return this.newRequest(id, new HashMap<String, String>());
    }

    @Override
    public OperationRequest newRequest(String id, Map<String, String> ctx) {
        OperationDocumentation op = this.getOperation(id);
        if (op == null) {
            throw new IllegalArgumentException("No such operation: " + id);
        }
        return new DefaultOperationRequest(this, op, ctx);
    }

    @Override
    public OperationDocumentation getOperation(String id) {
        return this.client.getRegistry().getOperation(id);
    }

    @Override
    public Map<String, OperationDocumentation> getOperations() {
        return this.client.getRegistry().getOperations();
    }

    @Override
    public boolean isOffline() {
        return this.client.isOffline();
    }

    @Override
    public String execDeferredUpdate(OperationRequest request, AsyncCallback<Object> cb, OperationType opType) {
        return this.client.execDeferredUpdate(request, cb, opType);
    }

    @Override
    public DocumentMessageService getMessageHelper() {
        return this.client.getMessageHelper();
    }
}

