/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.automation.client.jaxrs.LoginInfo;
import org.nuxeo.ecm.automation.client.jaxrs.OperationRequest;
import org.nuxeo.ecm.automation.client.jaxrs.RemoteException;
import org.nuxeo.ecm.automation.client.jaxrs.model.Document;
import org.nuxeo.ecm.automation.client.jaxrs.model.Documents;
import org.nuxeo.ecm.automation.client.jaxrs.model.OperationDocumentation;
import org.nuxeo.ecm.automation.client.jaxrs.model.OperationInput;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyList;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyMap;
import org.nuxeo.ecm.automation.client.jaxrs.spi.OperationRegistry;
import org.nuxeo.ecm.automation.client.jaxrs.util.JSONExporter;

public class JsonMarshalling {
    public static OperationRegistry readRegistry(String content) throws JSONException {
        JSONObject pathsObj;
        OperationDocumentation op;
        JSONObject obj;
        int i;
        int len;
        JSONObject json = new JSONObject(content);
        HashMap<String, OperationDocumentation> ops = new HashMap<String, OperationDocumentation>();
        HashMap<String, OperationDocumentation> chains = new HashMap<String, OperationDocumentation>();
        HashMap<String, String> paths = new HashMap<String, String>();
        JSONArray ar = json.getJSONArray("operations");
        if (ar != null) {
            len = ar.length();
            for (i = 0; i < len; ++i) {
                obj = ar.getJSONObject(i);
                op = JSONExporter.fromJSON(obj);
                ops.put(op.id, op);
            }
        }
        if ((ar = json.getJSONArray("chains")) != null) {
            len = ar.length();
            for (i = 0; i < len; ++i) {
                obj = ar.getJSONObject(i);
                op = JSONExporter.fromJSON(obj);
                chains.put(op.id, op);
            }
        }
        if ((pathsObj = json.getJSONObject("paths")) != null) {
            Iterator it = pathsObj.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = pathsObj.getString(key);
                paths.put(key, value);
            }
        }
        return new OperationRegistry(paths, ops, chains);
    }

    public static Object readEntity(String content) throws JSONException {
        if (content.length() == 0) {
            return null;
        }
        JSONObject json = new JSONObject(content);
        String type = json.getString("entity-type");
        if ("document".equals(type)) {
            return JsonMarshalling.readDocument(json);
        }
        if ("documents".equals(type)) {
            boolean batched = json.optBoolean("isPaginable", false);
            JSONArray ar = json.getJSONArray("entries");
            int size = ar.length();
            Documents docs = null;
            docs = batched ? new Documents(size, json.optInt("totalSize", 0), json.optInt("pageSize", 0), json.optInt("pageIndex", 0), json.optInt("pageCount", 0)) : new Documents(size);
            for (int i = 0; i < size; ++i) {
                JSONObject obj = ar.getJSONObject(i);
                docs.add(JsonMarshalling.readDocument(obj));
            }
            return docs;
        }
        if ("login".equals(type)) {
            return JsonMarshalling.readLogin(json);
        }
        if ("exception".equals(type)) {
            throw JsonMarshalling.readException(content);
        }
        throw new IllegalArgumentException("Unknown entity type: " + type);
    }

    public static RemoteException readException(String content) throws JSONException {
        return JsonMarshalling.readException(new JSONObject(content));
    }

    protected static RemoteException readException(JSONObject json) throws NumberFormatException, JSONException {
        return new RemoteException(Integer.parseInt(json.getString("status")), json.optString("type", null), json.optString("message"), json.optString("stack", null));
    }

    protected static LoginInfo readLogin(JSONObject json) throws JSONException {
        String username = json.getString("username");
        String isAdmin = json.optString("isAdministrator", "false");
        JSONArray groups = json.optJSONArray("groups");
        HashSet<String> set = new HashSet<String>();
        if (groups != null) {
            int size = groups.length();
            for (int i = 0; i < size; ++i) {
                set.add(groups.getString(i));
            }
        }
        return new LoginInfo(username, set, Boolean.parseBoolean(isAdmin));
    }

    protected static Document readDocument(JSONObject json) throws JSONException {
        JSONObject jsonProps;
        String uid = json.getString("uid");
        String path = json.getString("path");
        String repoName = json.getString("repository");
        String type = json.getString("type");
        String state = json.optString("state", null);
        String lock = json.optString("lock", null);
        String title = json.optString("title", null);
        String lastModified = json.optString("lastModified", null);
        String changeToken = json.optString("changeToken", null);
        JSONArray jsonFacets = json.optJSONArray("facets");
        PropertyList facets = null;
        if (jsonFacets != null) {
            facets = (PropertyList)JsonMarshalling.readValue(jsonFacets);
        }
        PropertyMap props = (jsonProps = json.optJSONObject("properties")) != null ? (PropertyMap)JsonMarshalling.readValue(jsonProps) : new PropertyMap();
        props.set("dc:title", title);
        props.set("dc:modified", lastModified);
        return new Document(repoName, uid, type, facets, changeToken, path, state, lock, props);
    }

    protected static Serializable readValue(Object o) throws JSONException {
        if (o == null) {
            return null;
        }
        if (o instanceof JSONArray) {
            JSONArray ar = (JSONArray)o;
            PropertyList plist = new PropertyList();
            List<Serializable> list = plist.list();
            int size = ar.length();
            for (int i = 0; i < size; ++i) {
                Serializable v = JsonMarshalling.readValue(ar.get(i));
                if (v == null) continue;
                list.add(v);
            }
            return plist;
        }
        if (o instanceof JSONObject) {
            JSONObject ob = (JSONObject)o;
            PropertyMap pmap = new PropertyMap();
            Map<String, Object> map = pmap.map();
            Iterator keys = ob.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Serializable v = JsonMarshalling.readValue(ob.get(key));
                map.put(key, v);
            }
            return pmap;
        }
        return o.toString();
    }

    public static String writeRequest(OperationRequest req) throws Exception {
        String ref;
        JSONObject entity = new JSONObject();
        OperationInput input = req.getInput();
        if (input != null && !input.isBinary() && (ref = input.getInputRef()) != null) {
            entity.put("input", (Object)ref);
        }
        entity.put("params", (Object)new JSONObject(req.getParameters()));
        entity.put("context", (Object)new JSONObject(req.getContextParameters()));
        return entity.toString();
    }
}

