/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.spi.auth;

import android.util.Log;
import org.apache.http.HttpRequest;
import org.nuxeo.ecm.automation.client.jaxrs.RequestInterceptor;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Connector;
import org.nuxeo.ecm.automation.client.jaxrs.spi.Request;

public class TokenRequestInterceptor
implements RequestInterceptor {
    private String token;
    private String login;
    private String deviceId;
    private String appName;

    public TokenRequestInterceptor(String appName, String token, String login, String deviceId) {
        this.token = token;
        this.login = login;
        this.deviceId = deviceId;
        this.appName = appName;
    }

    @Override
    public void processHttpRequest(HttpRequest request) {
        request.addHeader("X-User-Id", this.login);
        request.addHeader("X-Device-Id", this.deviceId);
        request.addHeader("X-Application-Name", this.appName);
        request.addHeader("X-Authentication-Token", this.token);
        Log.d((String)"TokenRequestInterceptor", (String)"processHttpRequest");
    }

    @Override
    public void processRequest(Request request, Connector connector) {
        request.put("X-User-Id", this.login);
        request.put("X-Device-Id", this.deviceId);
        request.put("X-Application-Name", this.appName);
        request.put("X-Authentication-Token", this.token);
        Log.d((String)"TokenRequestInterceptor", (String)"processRequest");
    }
}

