/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.client.jaxrs.util;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.automation.client.jaxrs.model.OperationDocumentation;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyList;
import org.nuxeo.ecm.automation.client.jaxrs.model.PropertyMap;

public class JSONExporter {
    public static String toJSON(List<OperationDocumentation> docs) throws IOException {
        StringWriter writer = new StringWriter();
        try {
            JSONExporter.toJSON(docs, writer);
        }
        catch (JSONException e) {
            throw new IOException("Error during JSON marshaling " + e.getMessage());
        }
        return writer.toString();
    }

    public static void toJSON(List<OperationDocumentation> docs, Writer writer) throws IOException, JSONException {
        JSONObject json = new JSONObject();
        JSONArray ops = new JSONArray();
        for (OperationDocumentation doc : docs) {
            JSONObject op = JSONExporter.toJSON(doc);
            ops.put((Object)op);
        }
        json.put("operations", (Object)ops);
        writer.write(json.toString(2));
    }

    public static JSONObject toJSON(OperationDocumentation doc) throws JSONException {
        JSONObject op = new JSONObject();
        op.put("id", (Object)doc.id);
        op.put("label", (Object)doc.label);
        op.put("category", (Object)doc.category);
        op.put("requires", (Object)doc.requires);
        op.put("description", (Object)doc.description);
        if (doc.since != null && doc.since.length() > 0) {
            op.put("since", (Object)doc.since);
        }
        op.put("url", (Object)doc.url);
        JSONArray sig = new JSONArray();
        for (String in : doc.signature) {
            sig.put((Object)in);
        }
        op.put("signature", (Object)sig);
        JSONArray params = new JSONArray();
        for (OperationDocumentation.Param p : doc.params) {
            JSONObject param = new JSONObject();
            param.put("name", (Object)p.name);
            param.put("type", (Object)p.type);
            param.put("required", p.isRequired);
            param.put("widget", (Object)p.widget);
            JSONArray ar = new JSONArray();
            for (String value : p.values) {
                ar.put((Object)value);
            }
            param.put("values", (Object)ar);
            params.put((Object)param);
        }
        op.put("params", (Object)params);
        return op;
    }

    public static OperationDocumentation fromJSON(JSONObject json) throws JSONException {
        JSONArray params;
        OperationDocumentation op = new OperationDocumentation(json.getString("id"));
        op.category = json.optString("label", null);
        op.category = json.optString("category", null);
        op.requires = json.optString("requires", null);
        op.description = json.optString("description", null);
        op.url = json.optString("url", op.id);
        JSONArray sig = json.optJSONArray("signature");
        if (sig != null) {
            op.signature = new String[sig.length()];
            int size = sig.length();
            for (int j = 0; j < size; ++j) {
                op.signature[j] = sig.getString(j);
            }
        }
        if ((params = json.optJSONArray("params")) != null) {
            op.params = new ArrayList<OperationDocumentation.Param>(params.length());
            int size = params.length();
            for (int j = 0; j < size; ++j) {
                JSONObject p = params.getJSONObject(j);
                OperationDocumentation.Param para = new OperationDocumentation.Param();
                para.name = p.optString("name", null);
                para.type = p.optString("type", null);
                para.isRequired = p.optBoolean("required", false);
                para.widget = p.optString("widget", null);
                JSONArray ar = p.optJSONArray("values");
                if (ar != null) {
                    para.values = new String[ar.length()];
                    int size2 = ar.length();
                    for (int k = 0; k < size2; ++k) {
                        para.values[k] = ar.getString(k);
                    }
                }
                op.params.add(para);
            }
        }
        return op;
    }

    public static PropertyMap getFromJSONString(String json) {
        try {
            JSONObject jsonObject = new JSONObject(json);
            return JSONExporter.getFromJSONObject(jsonObject);
        }
        catch (JSONException e) {
            throw new RuntimeException("Error in JSON Parsing", e);
        }
    }

    public static PropertyMap getFromJSONObject(JSONObject jsonMap) {
        PropertyMap map = new PropertyMap();
        try {
            Iterator keyIterator = jsonMap.keys();
            while (keyIterator.hasNext()) {
                String key = (String)keyIterator.next();
                Object value = jsonMap.get(key);
                if (value instanceof JSONObject) {
                    map.set(key, JSONExporter.getFromJSONObject((JSONObject)value));
                    continue;
                }
                if (value instanceof JSONArray) {
                    map.set(key, JSONExporter.getFromJSONArray((JSONArray)value));
                    continue;
                }
                map.map().put(key, value);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static PropertyList getFromJSONArray(JSONArray jsonArray) {
        PropertyList list = new PropertyList();
        try {
            for (int i = 0; i < jsonArray.length(); ++i) {
                Object value = jsonArray.get(i);
                if (value instanceof JSONObject) {
                    list.add(JSONExporter.getFromJSONObject((JSONObject)value));
                    continue;
                }
                if (value instanceof JSONArray) {
                    list.add(JSONExporter.getFromJSONArray((JSONArray)value));
                    continue;
                }
                list.list().add((Serializable)value);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static String toJSON(PropertyMap props) {
        try {
            JSONObject json = JSONExporter.asJSONObject(props);
            return json.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("JSON parsing error");
        }
    }

    protected static JSONObject asJSONObject(PropertyMap props) throws JSONException {
        JSONObject json = new JSONObject();
        for (Map.Entry<String, Object> entry : props.map().entrySet()) {
            if (entry.getValue() instanceof PropertyMap) {
                json.put(entry.getKey(), (Object)JSONExporter.asJSONObject((PropertyMap)entry.getValue()));
                continue;
            }
            if (entry.getValue() instanceof PropertyList) {
                json.put(entry.getKey(), (Object)JSONExporter.asJSONArray((PropertyList)entry.getValue()));
                continue;
            }
            json.put(entry.getKey(), entry.getValue());
        }
        return json;
    }

    protected static JSONArray asJSONArray(PropertyList props) throws JSONException {
        JSONArray array = new JSONArray();
        for (Serializable value : props.list()) {
            if (value instanceof PropertyMap) {
                array.put((Object)JSONExporter.asJSONObject((PropertyMap)value));
                continue;
            }
            if (value instanceof PropertyList) {
                array.put((Object)JSONExporter.asJSONArray((PropertyList)value));
                continue;
            }
            array.put((Object)value);
        }
        return array;
    }
}

