/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.nuxeo.build.ant.Version;

public class RemoveDuplicateTask
extends Task {
    static final Pattern PATTERN = Pattern.compile("-([0-9]+.*)\\.jar");
    protected File dir;

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void execute() throws BuildException {
        if (this.dir == null) {
            throw new BuildException("dir attribute is required");
        }
        String[] names = this.dir.list();
        if (names == null) {
            return;
        }
        HashMap<String, ArrayList<Entry>> map = new HashMap<String, ArrayList<Entry>>();
        for (String name : names) {
            Matcher m = PATTERN.matcher(name);
            if (!m.find()) continue;
            String key = name.substring(0, m.start());
            String v = m.group(1);
            Entry entry = new Entry(new File(this.dir, name), Version.parse(v));
            ArrayList<Entry> list = (ArrayList<Entry>)map.get(key);
            if (list == null) {
                list = new ArrayList<Entry>();
                map.put(key, list);
            }
            list.add(entry);
        }
        for (List list : map.values()) {
            this.removeAllButLatest(list);
        }
    }

    public static Entry getLatest(List<Entry> list) {
        if (list.isEmpty()) {
            return null;
        }
        Iterator<Entry> it = list.iterator();
        if (!it.hasNext()) {
            return null;
        }
        Entry latest = it.next();
        while (it.hasNext()) {
            Entry p = it.next();
            if (!p.version.greaterThan(latest.version)) continue;
            latest = p;
        }
        return latest;
    }

    public void removeAllButLatest(List<Entry> list) {
        Entry latest = RemoveDuplicateTask.getLatest(list);
        StringBuilder buf = new StringBuilder();
        for (Entry p : list) {
            if (p == latest) continue;
            buf.append(p.file.getName()).append(" ");
            p.file.delete();
        }
        if (buf.length() > 0) {
            this.log("removed duplicates: " + buf.toString() + "; preserved: " + latest.file.getName(), 2);
        }
    }

    static class Entry {
        protected File file;
        protected Version version;

        Entry(File file, Version version) {
            this.file = file;
            this.version = version;
        }
    }
}

