/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileProvider;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.ResourceUtils;
import org.nuxeo.studio.components.common.ContributionsExtractor;
import org.nuxeo.studio.components.common.ExtractorOptions;

public class StudioExtraction
extends Task {
    protected String extract = "*";
    protected File todir;
    protected String filename = "studio-registries.json";
    protected boolean failOnEmpty = false;
    protected Vector<ResourceCollection> rcs = new Vector();

    public void execute() throws BuildException {
        this.validateAttributes();
        try {
            new ContributionsExtractor(this.buildOptions()).publish();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void validateAttributes() {
        if (this.todir == null) {
            throw new BuildException("todir attribute cannot be empty");
        }
        if (this.rcs.isEmpty()) {
            throw new BuildException("Use nested FileSet(s) to set jar files to extract");
        }
    }

    public void addFileSet(FileSet fileSet) {
        this.add((ResourceCollection)fileSet);
    }

    public void add(ResourceCollection rc) {
        this.rcs.add(rc);
    }

    protected ExtractorOptions buildOptions() {
        ExtractorOptions opts = new ExtractorOptions();
        opts.setBuildDirectory(this.todir.getAbsolutePath());
        opts.setExtract(this.extract);
        opts.setFailOnEmpty(Boolean.valueOf(this.isFailOnEmpty()));
        opts.setOutput(this.filename);
        ArrayList<String> files = new ArrayList<String>();
        for (ResourceCollection rc : this.rcs) {
            if (rc instanceof FileSet) {
                FileSet fs = (FileSet)rc;
                File basedir = fs.getDirectoryScanner().getBasedir();
                for (String file : fs.getDirectoryScanner().getIncludedFiles()) {
                    files.add(new File(basedir, file).getAbsolutePath());
                }
                continue;
            }
            if (!rc.isFilesystemOnly()) {
                throw new BuildException("Only FileSystem resources are supported.");
            }
            for (Resource r : rc) {
                if (!r.isExists()) {
                    this.log("Warning: Could not find resource " + r.toLongString());
                    continue;
                }
                FileProvider fp = (FileProvider)r.as(FileProvider.class);
                if (fp == null) continue;
                FileResource fr = ResourceUtils.asFileResource((FileProvider)fp);
                files.add(fr.getFile().getAbsolutePath());
            }
        }
        opts.setJarFile(StringUtils.join(files, (String)","));
        return opts;
    }

    public void setTodir(File todir) {
        this.todir = todir;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setExtract(String extract) {
        this.extract = extract;
    }

    public boolean isFailOnEmpty() {
        return this.failOnEmpty;
    }

    public void setFailOnEmpty(boolean failOnEmpty) {
        this.failOnEmpty = failOnEmpty;
    }
}

