/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyResult;
import org.nuxeo.build.ant.artifact.ArtifactSet;
import org.nuxeo.build.ant.artifact.Excludes;
import org.nuxeo.build.ant.artifact.Expand;
import org.nuxeo.build.ant.artifact.Includes;
import org.nuxeo.build.maven.AntBuildMojo;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.filter.AndFilter;
import org.nuxeo.build.maven.filter.CompositeFilter;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.graph.DependencyUtils;
import org.nuxeo.build.maven.graph.Graph;
import org.nuxeo.build.maven.graph.Node;

public class ArtifactDependencies
extends DataType
implements ResourceCollection {
    protected Graph graph = AntBuildMojo.getInstance().getGraph();
    protected Node node;
    protected List<Artifact> artifacts;
    public String key;
    public int depth = 1;
    public ArtifactDescriptor ad = new ArtifactDescriptor();
    public Includes includes;
    public Excludes excludes;

    public void setDepth(String depth) {
        this.depth = Expand.readExpand(depth);
    }

    public void addExcludes(Excludes excludes) {
        if (this.excludes != null) {
            throw new BuildException("Found an Excludes that is defined more than once in an artifact dependencies");
        }
        this.excludes = excludes;
    }

    public void addIncludes(Includes includes) {
        if (this.includes != null) {
            throw new BuildException("Found an Includes that is defined more than once in an artifact dependencies");
        }
        this.includes = includes;
    }

    public void setKey(String pattern) {
        this.key = pattern;
        this.ad = ArtifactDescriptor.parseQuietly(pattern);
    }

    public void setArtifactId(String artifactId) {
        this.ad.setArtifactId(artifactId);
    }

    public void setGroupId(String groupId) {
        this.ad.setGroupId(groupId);
    }

    public void setType(String type) {
        this.ad.setType(type);
    }

    public void setVersion(String version) {
        this.ad.setVersion(version);
    }

    public Node getNode() {
        if (this.node == null) {
            this.node = this.graph.findNode(this.key, this.ad);
        }
        return this.node;
    }

    public List<Artifact> getArtifacts() {
        if (this.artifacts == null) {
            Filter filter = Filter.ANY;
            if (this.includes != null || this.excludes != null) {
                AndFilter andf = new AndFilter();
                if (this.includes != null) {
                    andf.addFilter(this.includes.getFilter());
                }
                if (this.excludes != null) {
                    andf.addFilter(this.excludes.getFilter());
                }
                filter = CompositeFilter.compact(andf);
            }
            DependencyResult result = DependencyUtils.resolveDependencies(this.getNode(), filter, this.depth);
            List results = result.getArtifactResults();
            this.artifacts = new ArrayList<Artifact>();
            for (ArtifactResult artifactResult : results) {
                this.artifacts.add(artifactResult.getArtifact());
            }
            if (!filter.accept(result.getRoot(), null)) {
                Artifact root = result.getRoot().getArtifact();
                this.artifacts.remove(root);
            }
        }
        return this.artifacts;
    }

    public Iterator<Resource> iterator() {
        return ArtifactSet.createIterator(this.getArtifacts());
    }

    public int size() {
        return this.getArtifacts().size();
    }

    public boolean isFilesystemOnly() {
        return true;
    }
}

