/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.tools.ant.ExitStatusException;
import org.apache.tools.ant.taskdefs.optional.testing.BuildTimeoutException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.nuxeo.build.maven.AntBuildMojo;

@Mojo(name="integration-test", defaultPhase=LifecyclePhase.INTEGRATION_TEST, threadSafe=true, requiresProject=true, requiresDependencyResolution=ResolutionScope.TEST)
public class IntegrationTestMojo
extends AntBuildMojo {
    private static final String FAILSAFE_IN_PROGRESS_CONTEXT_KEY = "failsafe-in-progress";
    @Deprecated
    @Parameter(defaultValue="true", property="maven.test.failure.ignore")
    protected boolean testFailureIgnore;
    @Parameter(defaultValue="${project.build.directory}/nxtools-reports/nxtools-summary.xml", required=true)
    protected File summaryFile;
    @Parameter(property="skipITs")
    protected boolean skipITs;
    @Parameter(defaultValue="${project.reporting.outputEncoding}")
    protected String reportingEncoding;

    @Override
    public String getEncoding() {
        if (StringUtils.isEmpty((String)this.reportingEncoding)) {
            this.reportingEncoding = super.getEncoding();
        }
        return this.reportingEncoding;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        File[] testBuildFiles;
        if (this.skipITs) {
            this.getLog().info((CharSequence)"Tests are skipped.");
            return;
        }
        RunResult result = RunResult.noTestsRun();
        boolean failFast = this.failOnError;
        this.failOnError = true;
        for (File file : testBuildFiles = this.getBuildFiles()) {
            this.buildFiles = null;
            this.buildFile = file;
            try {
                super.execute();
                result = result.aggregate(new RunResult(1, 0, 0, 0));
            }
            catch (MojoExecutionException | MojoFailureException e) {
                if (e.getCause() instanceof ExitStatusException) {
                    ExitStatusException exit = (ExitStatusException)e.getCause();
                    this.getLog().debug((CharSequence)("Result: " + exit.getStatus()));
                    this.getLog().debug((CharSequence)exit.getMessage());
                    result = result.aggregate(new RunResult(1, 1, 0, 0));
                } else {
                    Throwable cause = e.getCause();
                    if (cause == null) {
                        cause = e;
                    }
                    this.getLog().error((CharSequence)cause.getMessage(), cause);
                    result = result.aggregate(new RunResult(1, 0, 1, 0, cause.getMessage(), cause instanceof BuildTimeoutException));
                }
                if (failFast) break;
            }
        }
        this.writeSummary(result);
    }

    protected void writeSummary(RunResult summary) throws MojoExecutionException {
        if (!this.summaryFile.getParentFile().isDirectory()) {
            this.summaryFile.getParentFile().mkdirs();
        }
        OutputStream fout = null;
        InputStream fin = null;
        try {
            Object token = this.getPluginContext().get(FAILSAFE_IN_PROGRESS_CONTEXT_KEY);
            summary.writeSummary(this.summaryFile, token != null, this.getEncoding());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            IOUtil.close(fin);
            IOUtil.close(fout);
        }
        this.getPluginContext().put(FAILSAFE_IN_PROGRESS_CONTEXT_KEY, FAILSAFE_IN_PROGRESS_CONTEXT_KEY);
    }
}

