/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.SurefireReportParameters;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.apache.maven.plugins.surefire.report.SurefireReportParser;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.surefire.suite.RunResult;
import org.codehaus.plexus.util.StringUtils;
import org.nuxeo.build.maven.IntegrationTestMojo;

@Mojo(name="verify", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true, requiresProject=true, requiresDependencyResolution=ResolutionScope.TEST)
public class VerifyMojo
extends IntegrationTestMojo
implements SurefireReportParameters {
    @Parameter
    protected File[] summaryFiles;
    @Parameter(property="createSummary", defaultValue="false")
    private boolean createSummary;
    @Parameter(defaultValue="${project.build.directory}/nxtools-reports")
    private File reportsDirectory;
    @Parameter(property="skipTests")
    protected boolean skipTests;
    @Parameter(property="maven.test.failure.ignore", defaultValue="false")
    protected boolean testFailureIgnore;
    @Parameter(property="failIfNoTests")
    protected Boolean failIfNoTests;

    @Override
    public String getEncoding() {
        if (StringUtils.isEmpty((String)this.reportingEncoding)) {
            this.reportingEncoding = super.getEncoding();
        }
        return this.reportingEncoding;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkipITs() || this.isSkipTests()) {
            this.getLog().info((CharSequence)"Tests are skipped.");
            return;
        }
        RunResult summary = RunResult.noTestsRun();
        if (this.createSummary) {
            File[] reportsDirectories = Collections.singletonList(this.reportsDirectory);
            SurefireReportParser parser = new SurefireReportParser(reportsDirectories, Locale.getDefault());
            try {
                List reports = parser.parseXMLReportFiles();
                if (reports.isEmpty()) {
                    this.getLog().info((CharSequence)("No report found in " + this.reportsDirectory));
                }
                int total = 0;
                int errors = 0;
                int failures = 0;
                int skipped = 0;
                int flakes = 0;
                for (ReportTestSuite report : reports) {
                    total += report.getNumberOfTests();
                    errors += report.getNumberOfErrors();
                    failures += report.getNumberOfFailures();
                    skipped += report.getNumberOfSkipped();
                    flakes += report.getNumberOfFlakes();
                }
                summary = new RunResult(total, errors, failures, skipped, flakes);
            }
            catch (MavenReportException e) {
                this.getLog().error((CharSequence)("Could not parse reports from " + this.reportsDirectory), (Throwable)e);
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
        try {
            if (this.summaryFile.isFile()) {
                summary = summary.aggregate(this.readSummary(this.getEncoding(), this.summaryFile));
            }
            if (this.summaryFiles != null) {
                for (File file : this.summaryFiles) {
                    summary = summary.aggregate(this.readSummary(this.getEncoding(), file));
                }
            }
            if (this.createSummary) {
                this.writeSummary(summary);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        SurefireHelper.reportExecution((SurefireReportParameters)this, (RunResult)summary, (Log)this.getLog());
    }

    private RunResult readSummary(String sumEncoding, File sumFile) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(sumFile));){
            RunResult runResult = RunResult.fromInputStream((InputStream)in, (String)sumEncoding);
            return runResult;
        }
    }

    public boolean isSkipITs() {
        return this.skipITs;
    }

    public void setSkipITs(boolean skipITs) {
        this.skipITs = skipITs;
    }

    public boolean isSkipTests() {
        return this.skipTests;
    }

    public void setSkipTests(boolean skipTests) {
        this.skipTests = skipTests;
    }

    @Deprecated
    public boolean isSkipExec() {
        return this.isSkipITs() || this.isSkipTests();
    }

    @Deprecated
    public void setSkipExec(boolean skipExec) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean isSkip() {
        return this.isSkipITs() || this.isSkipTests();
    }

    @Deprecated
    public void setSkip(boolean skip) {
        throw new UnsupportedOperationException();
    }

    public boolean isTestFailureIgnore() {
        return this.testFailureIgnore;
    }

    public void setTestFailureIgnore(boolean testFailureIgnore) {
        this.testFailureIgnore = testFailureIgnore;
    }

    public File getBasedir() {
        return this.project.getBasedir();
    }

    public void setBasedir(File basedir) {
        throw new UnsupportedOperationException();
    }

    public File getTestClassesDirectory() {
        return new File(this.project.getBuild().getTestOutputDirectory());
    }

    public void setTestClassesDirectory(File testClassesDirectory) {
        throw new UnsupportedOperationException();
    }

    public File getReportsDirectory() {
        return this.summaryFile.getParentFile();
    }

    public void setReportsDirectory(File reportsDirectory) {
        throw new UnsupportedOperationException();
    }

    public Boolean getFailIfNoTests() {
        return this.failIfNoTests;
    }

    public void setFailIfNoTests(boolean failIfNoTests) {
        throw new UnsupportedOperationException();
    }
}

