/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.graph;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.nuxeo.build.ant.AntClient;

public abstract class AbstractDependencyVisitor
implements DependencyVisitor {
    private final Map<DependencyNode, Object> visitedNodes;
    protected final Map<String, DependencyNode> nodesMap = new HashMap<String, DependencyNode>();
    protected final List<DependencyNode> ignores;
    protected List<String> scopes = null;

    public Collection<DependencyNode> getNodes() {
        return this.nodesMap.values();
    }

    public void addIgnores(Collection<? extends DependencyNode> nodesToIgnore) {
        this.ignores.addAll(nodesToIgnore);
    }

    public AbstractDependencyVisitor(List<String> scopes) {
        this.visitedNodes = new IdentityHashMap<DependencyNode, Object>();
        this.ignores = new ArrayList<DependencyNode>();
        this.scopes = scopes;
    }

    protected boolean setVisited(DependencyNode node) {
        return this.visitedNodes.put(node, Boolean.TRUE) == null;
    }

    public boolean visitEnter(DependencyNode node) {
        boolean newNode;
        boolean visitChildren = newNode = this.setVisited(node);
        boolean ignoreNode = false;
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            AntClient.getInstance().log("Ignored node with null dependency: " + node);
            ignoreNode = true;
        } else if (dependency.getScope() == null || "".equals(dependency.getScope())) {
            AntClient.getInstance().log(String.format("Found node %s with null scope!", node), 4);
        } else if (this.scopes != null && !this.scopes.contains(dependency.getScope())) {
            AntClient.getInstance().log(String.format("Ignored node %s which scope is %s", node, dependency.getScope()), 4);
            ignoreNode = true;
        }
        if (this.ignores != null && this.ignores.contains(node)) {
            AntClient.getInstance().log("Ignored node as requested: " + node, 4);
            ignoreNode = true;
        }
        if (ignoreNode) {
            visitChildren = false;
            this.ignores.add(node);
        } else {
            DependencyNode winner = (DependencyNode)node.getData().get("conflict.winner");
            if (winner != null && !ArtifactIdUtils.equalsId((Artifact)node.getArtifact(), (Artifact)winner.getArtifact())) {
                newNode = false;
            }
            if (newNode) {
                this.nodesMap.put(node.getArtifact().toString(), node);
            }
            this.doVisit(node, newNode);
        }
        return visitChildren;
    }

    protected abstract void doVisit(DependencyNode var1, boolean var2);

    public boolean visitLeave(DependencyNode node) {
        return true;
    }

    public List<Dependency> getDependencies(boolean includeUnresolved) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(this.getNodes().size());
        for (DependencyNode node : this.getNodes()) {
            Dependency dependency = node.getDependency();
            if (dependency == null || !includeUnresolved && dependency.getArtifact().getFile() == null) continue;
            dependencies.add(dependency);
        }
        return dependencies;
    }

    public List<Artifact> getArtifacts(boolean includeUnresolved) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(this.getNodes().size());
        for (DependencyNode node : this.getNodes()) {
            Artifact artifact = node.getArtifact();
            if (artifact == null || !includeUnresolved && artifact.getFile() == null) continue;
            artifacts.add(artifact);
        }
        return artifacts;
    }

    public List<File> getFiles() {
        ArrayList<File> files = new ArrayList<File>(this.getNodes().size());
        for (DependencyNode node : this.getNodes()) {
            File file;
            if (node.getDependency() == null || (file = node.getDependency().getArtifact().getFile()) == null) continue;
            files.add(file);
        }
        return files;
    }

    public String getClassPath() {
        StringBuilder buffer = new StringBuilder(1024);
        Iterator<DependencyNode> it = this.getNodes().iterator();
        while (it.hasNext()) {
            DependencyNode node = it.next();
            Artifact artifact = node.getArtifact();
            if (artifact == null || artifact.getFile() == null) continue;
            buffer.append(artifact.getFile().getAbsolutePath());
            if (!it.hasNext()) continue;
            buffer.append(File.pathSeparatorChar);
        }
        return buffer.toString();
    }
}

