/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.api.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.nuxeo.client.api.cache.NuxeoResponseCache;
import org.nuxeo.client.internals.spi.NuxeoClientException;
import retrofit2.Response;

public class ResultCacheInMemory
implements NuxeoResponseCache {
    protected final Cache<String, Object> cache;
    protected static final Integer CACHE_CONCURRENCY_LEVEL = 10;
    protected static final Integer CACHE_MAXIMUM_SIZE = 1000;
    protected static final Integer CACHE_TIMEOUT = 10;

    public Cache<String, Object> getCache() {
        return this.cache;
    }

    public ResultCacheInMemory() {
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(CACHE_CONCURRENCY_LEVEL.intValue()).maximumSize((long)CACHE_MAXIMUM_SIZE.intValue()).expireAfterWrite((long)CACHE_TIMEOUT.intValue(), TimeUnit.MINUTES).build();
    }

    public ResultCacheInMemory(int cache_concurrency_level, long cache_maximum_size, long cache_timeout, TimeUnit time_unit) {
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(cache_concurrency_level).maximumSize(cache_maximum_size).expireAfterWrite(cache_timeout, time_unit).build();
    }

    @Override
    public Object getResponse(Object key) {
        return this.cache.getIfPresent(key);
    }

    @Override
    public void put(String key, Object value) {
        this.cache.put((Object)key, value);
    }

    @Override
    public int size() {
        return this.cache.asMap().size();
    }

    @Override
    public Object getRaw(Object key) {
        Object result = this.cache.getIfPresent(key);
        if (result == null) {
            return null;
        }
        try {
            return ((Response)result).raw().body().string();
        }
        catch (IOException reason) {
            throw new NuxeoClientException(reason);
        }
    }

    @Override
    public Object getBody(Object key) {
        Object result = this.cache.getIfPresent(key);
        if (result == null) {
            return null;
        }
        return ((Response)result).body();
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
    }
}

